function [x,fval,exitflag,output,lambda]=xprsqp(H,f,A,b,rtype,lb,ub,options)
%%
% Purpose
% Solve quadratic programming problems with Xpress.
%
% Syntax
%    x = xprsqp(H,f,A,b,rtype,lb,ub,options)
%    [x,fval,exitflag,output,lambda] = xprsqp(...)
%
% Description
% Finds the minimum of a problem specified by
%    min     0.5*x'*H*x+f*x
%    st.     A*x ~ b (where ~ can be <=, =, or >=)
%            lb <= x <= ub
%
% H is an n x n matrix; A is an m x n matrix; f, b, rtype, lb and ub are
% vectors.
% Input arguments rtype and followings can be omitted, with the condition
% that, if one is omitted, also all the following ones must be omitted (as
% in x=xprsqp(H, f, A, b, rtype)). Omitting an input argument has the 
% same effect as passing an empty array [].
% All output arguments can be omitted too, again with the condition that,
% if one is omitted, also all the following ones must be omitted (as in [x,
% fval]=xprsqp(H, f, A, b, rtype)).
%
% Note If the specified input bounds for a problem are inconsistent, the
% output x and fval are set to [].
%
% Input Arguments
% H         Matrix for quadratic objective terms.
% f         Linear objective function vector.
% A         Matrix for linear constraints.
% b         Vector for constraints rhs.
% rtype     Character vector (string) giving the row types:
%           L indicates a <= row;
%           E indicates a = row;
%           G indicates a >= row;
%           N indicates a free row.
%           If rtype=[], all rows are assumed to be of type 'L'.
%           If rtype is a single character, all constraints are assigned
%           the corresponding type.
% lb        Lower bounds. If lb=[] it means there are no lower bounds.
%           If lb is a scalar, x is uniformely bounded by that scalar.
% ub        Upper bounds. If ub=[] it means there are no upper bounds.
%           If ub is a scalar, x is uniformely bounded by that scalar.
% options   Options structure created with optimset or xprsoptimset
%           functions. See xprsoptimset for more details.
%
% Output Arguments
% x         Solution found by the optimization function. If exitflag>0,
%           then x is a solution; otherwise, x is the value of the
%           optimization routine when it terminated prematurely.
% fval      Value of the objective function at the solution x.
% exitflag  Integer identifying the reason the optimization algorithm
%           terminated. The following lists the values of exitflag and the
%           corresponding reasons the algorithm terminated.
%           1  Function converged to a solution x (LPSTATUS=OPTIMAL)
%           0  Number of iterations exceeded iter limit (LPSTATUS=
%           UNFINISHED and STOPSTATUS=ITERLIMIT).
%           -2 No feasible point was found (LPSTATUS=INFEAS).
%           -3 Problem is unbounded (LPSTATUS=UNDOUNDED).
%           -8 Other stop reason, see LPSTATUS and STOPSTATUS for details.
% output    Structure containing information about the optimization and,
%           eventually, values of Xpress controls and attributes. See
%           bintprog and the section 'Setting and querying control and
%           attributes' for details.
% lambda    Structure containing the Lagrange multipliers at the solution
%           x (separated by constraint type). The fields of the structure
%           are:
%           lower   Lower bounds lb
%           upper   Upper bounds ub
%           lin     Linear constraints from matrix A
%
% See also xprsoptimset, quadprog

% ---------------------------------------------------------------------------
% File: xprsqp.m
% ---------------------------------------------------------------------------
% Published by Fair Isaac Corporation
% Copyright (C) Fair Isaac Corporation 2010-2025. All rights reserved.