function options=xprsoptimset(varargin)
%%
% Purpose
% Create or edit Xpress optimization options structures.  
%
% Syntax
%    options = xprsoptimset('param1',value1,'param2',value2,...)
%    options = xprsoptimset
%    options = xprsoptimset(oldopts,'param1',value1,...)
%    options = xprsoptimset(oldopts,newopts)
%
% Description
% The function xprsoptimset creates an options structure that you can pass
% as an input argument to the Xpress optimization functions. You can use
% the options structure to change the default parameters for these
% functions.
%
% options = xprsoptimset('param1',value1,'param2',value2,...) creates an 
% optimization options structure called options, in which the specified
% parameters (param) have specified values. The parameter names are case
% sensitive and must be valid Xpress control parameter names.
%
% xprsoptimset with no input returns a complete list of parameters with
% their default values.
%
% options = xprsoptimset(oldopts,'param1',value1,...) creates a copy of
% oldopts, modifying or adding the specified parameters with the specified
% values.
%
% options = xprsoptimset(oldopts,newopts) combines an existing options
% structure oldopts with a new options structure newopts. Any parameters in
% newopts with nonempty values overwrite the corresponding old parameters
% in oldopts.
%
% In the last two cases, oldopts can be a MATLAB Toolbox option structure,
% in which case the following parameters are converted to the corresponding
% Xpress controls (others are ignored):
%   Display -> OUTPUTLOG, MIPLOG, LPLOG
%   MaxIter -> LPITERLIMIT
%   TolRLPFun -> OPTIMALITYTOL
%   MaxTime -> MAXTIME
%   MaxNode -> MAXNODE
%   NodeDisplayInterval -> MIPLOG
%   NodeSearchStrategy -> NODESELECTION
%   TolXInteger -> MIPTOL
%
% Only options that are set to a non-empty value are taken into consideration.
%
% Examples
% This statement creates an optimization options structure called options
% in which the FEASTOL parameter is set to 1e-8 and the MAXMIPSOL parameter
% is set to 10.
%     options = xprsoptimset('FEASTOL',1e-8,'MAXMIPSOL',10)
%
% This statement makes a copy of the options structure called options,
% changing the value of the PRESOLVE parameter and storing new values in
% optnew.
%     optnew = xprsoptimset(options,'PRESOLVE',0);
%
% This statement creates an Xpress optimization options structure with
% control values corresponding to the 'final' value of the MATLAB Toolbox
% option Display.
%     options = xprsoptimset(optimset('Display', 'final'));
%
% This statement returns an optimization options structure that contains
% all the parameter names and default values..
%     defaults = xprsoptimset
%
% See also xprsoptimget

% ---------------------------------------------------------------------------
% File: xprsoptimget.m
% ---------------------------------------------------------------------------
% Published by Fair Isaac Corporation
% Copyright (C) Fair Isaac Corporation 2010-2025. All rights reserved.