function out=xprsoptimget(options,name,default)
%%
% Purpose
% Retrieve Xpress optimization options values.
%
% Syntax
%    val = xprsoptimget(options,'param')
%    val = xprsoptimget(options,'param',default)
%
% Description
% val = xprsoptimget(options,'param') returns the value of the specified
% parameter in the optimization options structure options. The parameter
% name is case sensitive and must be a valid Xpress control parameter name.
%
% val = xprsoptimget(options,'param',default) returns default if the
% specified parameter is not defined in the optimization options structure
% options.
%
% Examples
% This statement returns the value of the FEASTOL optimization control
% parameter in the structure called my_options:
%     val = xprsoptimget(my_options,'FEASTOL')
% This statement returns the value of the FEASTOL optimization control
% parameter in the structure called my_options (as in the previous example)
% except that if the FEASTOL parameter is not defined, it returns the value
% 1e-6:
%     optnew = xprsoptimget(my_options,'FEASTOL',1e-6);
%
% See also xprsoptimset

% ---------------------------------------------------------------------------
% File: xprsoptimget.m
% ---------------------------------------------------------------------------
% Published by Fair Isaac Corporation
% Copyright (C) Fair Isaac Corporation 2010-2025. All rights reserved.