function [x,fval,exitflag,output]=xprsmiqp(H,f,A,b,rtype,ctype,clim,mipstructs,lb,ub,x0,options)
%%
% Purpose
% Solve mixed integer quadratic programming problems with Xpress.
%
% Syntax
%    x = xprsmiqp(H,f,A,b,rtype,ctype,clim,mipstructs,lb,ub,x0,options)
%    [x,fval,exitflag,output] = xprsmiqp(...)
%
% Description
% Finds the minimum of a problem specified by
%    min     0.5*x'*H*x+f*x
%    st.     A*x ~ b (where ~ can be <=, =, or >=)
%            x in the domain specified by the ctype, clim and mipstructs arguments
%
% H is an n x n matrix; A is an m x n matrix; f, b, rtype, ctype, clim, lb,
% ub and x0 are vectors; mipstructs is a struct vector.
% Input arguments rtype and followings can be omitted, with the condition
% that, if one is omitted, also all the following ones must be omitted (as
% in x=xprsmiqp(H, f, A, b, rtype)). Omitting an input argument has the 
% same effect as passing an empty array [].
% All output arguments can be omitted too, again with the condition that,
% if one is omitted, also all the following ones must be omitted (as in [x,
% fval]=xprsmiqp(H, f, A, b, rtype)).
%
% Note If the specified input bounds for a problem are inconsistent, the
% output x and fval are set to [].
%
% Input Arguments
% H         Matrix for quadratic objective terms.
% f         Linear objective function vector.
% A         Matrix for linear constraints.
% b         Vector for constraints rhs.
% rtype     Character vector (string) giving the row types:
%           L indicates a <= row;
%           E indicates a = row;
%           G indicates a >= row;
%           N indicates a free row.
%           If rtype=[], all rows are assumed to be of type 'L'.
%           If rtype is a single character, all constraints are assigned
%           the corresponding type.
% ctype     Character vector (string) giving the column types:
%           C or \0 continuous variables;
%           B binary variables;
%           I integer variables;
%           P partial integer variables;
%           S semi-continuous variables;
%           R semi-continuous integers.
%           If ctype=[], all columns are assumed to be of type 'C'.
%           If ctype is a single character, all columns are assigned the
%           corresponding type.
% clim      Vector containing the integer limits for the partial integer
%           variables and lower bounds for semi-continuous and
%           semi-continuous integer variables (column types 'P', 'S, 'R').
%           Values in the positions corresponding to all other columns are
%           ignored.
%           clim is mandatory if there are any 'P', ' S' or 'R' columns.
%           If clim is a scalar, all columns are assigned to that same
%           limit.
% mipstructs  Struct vector defining additional MIP constraints. The
%           number of MIP structs is given by the number of elements in
%           the struct. Each struct must have mipstructs(i).type, which
%           defines the constraint type and the remainder of the struct:
%           mipstructs(i).type = '1' or '2'
%				These define SOS1 or SOS2 constraints, in this case the
%               struct needs to define the following additional vectors:
%				mipstructs(i).ind : numeric vector with the indices of
%									columns in the set (column indices
%									start from 0)
%				mipstructs(i).wt:   numeric vector with the reference
%									row weights corresponding to the
%									columns in the mipstructs(i).ind vector.
%									It must have the same length as
%									mipstructs(i).ind
%			mipstructs(i).type = 'i'
%				This declares one of the rows in the constraint matrix as
%				an indicator constraint. In this case the following additional
%				entries are required:
%				mipstructs(i).row:  0-based index of a row in the A-matrix
%									that should be changed to an indicator
%				mipstructs(i).col:  0-based index of the binary indicator
%									variable that should activate the
%									constraint
%				mipstructs(i).comp: Either +1 if the row should be active
%									if the variable takes value one or -1
%									if the row should be active if the
%									binary takes value zero.
%			mipstructs(i).type = 'p'
%				This declares a piecewise linear constraint y = f(x) and
%				requires the following additional arguments:
%				mipstructs(i).res: 0-based index of the resulting column y
%				mipstructs(i).col: 0-based index of the input column x
%				mipstructs(i).x:   numeric vector with x-coordinates of
%								   breakpoints that combined define
%								   function f (for more details please refer
%								   to the C documentation)
%				mipstructs(i).y:   numeric vector with y-coordinates of
%								   breakpoints
%			mipstructs(i).type = 'n' or 'x' or 'd' or 'r' or 's'
%				This declares a miN, maX, anD, oR or abS general constraint
%				(like y = max (x_i)) with the following additional struct members:
%				mipstructs(i).res:  0-based index of the resulting column y
%				mipstructs(i).cols: numeric vector with the indices of
%								    the input columns x_i (column indices
%								    start from 0); for abs this has to be a
%								    single index.
%				mipstructs(i).vals: numeric vector of constants to include
%								    in the min/max (ignored for and/or/abs)
% lb        Lower bounds. If lb=[] it means there are no lower bounds.
%           If lb is a scalar, x is uniformely bounded by that scalar.
% ub        Upper bounds. If ub=[] it means there are no upper bounds.
%           If ub is a scalar, x is uniformely bounded by that scalar.
% x0        Optional initial known solution used to speed-up search.
% options   Options structure created with optimset or xprsoptimset
%           functions. See xprsoptimset for more details.
%
% Output Arguments
% x         Solution found by the optimization function. If exitflag>0,
%           then x is a solution; otherwise, x is the value of the
%           optimization routine when it terminated prematurely.
% fval      Value of the objective function at the solution x.
% exitflag  Integer identifying the reason the optimization algorithm
%           terminated. The following lists the values of exitflag and the
%           corresponding reasons the algorithm terminated.
%           1  Function converged to a solution x (MIPSTATUS=MIP_OPTIMAL).
%           0  Number of iterations exceeded iter limit (STOPSTATUS=
%              STOP_ITERLIMIT).
%           -2 The problem is infeasible (MIPSTATUS=MIP_INFEAS).
%           -4 Number of searched nodes exceeded limit (STOPSTATUS=
%              STOP_NODELIMIT).
%           -5 Search time exceeded limit (STOPSTATUS= STOP_TIMELIMIT).
%           -8 Other stop reason, see MIPSTATUS and STOPSTATUS for details.
% output    Structure containing information about the optimization and,
%           eventually, values of Xpress controls and attributes. See
%           bintprog and the section 'Setting and querying control and
%           attributes' for details.
%
% See also xprsoptimset, bintprog, quadprog

% ---------------------------------------------------------------------------
% File: xprsmiqp.m
% ---------------------------------------------------------------------------
% Published by Fair Isaac Corporation
% Copyright (C) Fair Isaac Corporation 2010-2025. All rights reserved.