function [x,fval,exitflag,output]=xprsbip(f,A,b,rtype,x0,options)
%%
% Purpose
% Solve binary integer programming problems with Xpress.
%
% Syntax
%    x = xprsbip(f,A,b,rtype,x0,options)
%    [x,fval,exitflag,output] = xprsbip(...)
%
% Description
% Finds the minimum of a problem specified by
%    min     f*x
%    st.     A*x ~ b (where ~ can be <=, =, or >=)
%            x binary
%
% A is an m x n matrix; f, b, rtype, lb, ub and x0 are vectors.
% Input arguments rtype, x0 and options can be omitted, with the condition
% that, if one is omitted, also all the following ones must be omitted (as
% in x=xprsbip(f, A, b, rtype)). Omitting an input argument has the same
% effect as passing an empty array [].
% All output arguments can be omitted too, again with the condition that,
% if one is omitted, also all the following ones must be omitted (as in [x,
% fval]=xprsbip(f, A, b, rtype)).
%
% Note If the specified input bounds for a problem are inconsistent, the
% output x and fval are set to [].
%
% Input Arguments
% f         Linear objective function vector.
% A         Matrix for linear constraints.
% b         Vector for constraints rhs.
% rtype     Character vector (string) giving the row types:
%           L indicates a <= row;
%           E indicates a = row;
%           G indicates a >= row;
%           N indicates a free row.
%           If rtype=[], all rows are assumed to be of type 'L'.
%           If rtype is a single character, all constraints are assigned
%           the corresponding type.
% x0        Optional initial known solution used to speed-up search.
% options   Options structure created with optimset or xprsoptimset
%           functions. See xprsoptimset for more details.
%
% Output Arguments
% x         Solution found by the optimization function. If exitflag>0,
%           then x is a solution; otherwise, x is the value of the
%           optimization routine when it terminated prematurely.
% fval      Value of the objective function at the solution x.
% exitflag  Integer identifying the reason the optimization algorithm
%           terminated. The following lists the values of exitflag and the
%           corresponding reasons the algorithm terminated.
%           1  Function converged to a solution x (MIPSTATUS=MIP_OPTIMAL).
%           0  Number of iterations exceeded iter limit (STOPSTATUS=
%              STOP_ITERLIMIT).
%           -2 The problem is infeasible (MIPSTATUS=MIP_INFEAS).
%           -4 Number of searched nodes exceeded limit (STOPSTATUS=
%              STOP_NODELIMIT).
%           -5 Search time exceeded limit (STOPSTATUS= STOP_TIMELIMIT).
%           -8 Other stop reason, see MIPSTATUS and STOPSTATUS for details.
% output    Structure containing information about the optimization and,
%           eventually, values of Xpress controls and attributes. See
%           bintprog and the section 'Setting and querying control and
%           attributes' for details.
%
% See also xprsoptimset, bintprog

% ---------------------------------------------------------------------------
% File: xprsbip.m
% ---------------------------------------------------------------------------
% Published by Fair Isaac Corporation
% Copyright (C) Fair Isaac Corporation 2010-2025. All rights reserved.