function [retcode,exitcode]=moselexec(srcfile,parlist,options)
%%
% Purpose
% Execute a Mosel program.
%
% Syntax
%    moselexec(srcfile)
%    moselexec(srcfile,parlist)
%    moselexec(srcfile,parlist,options)
%    retcode=moselexec(..)
%    [retcode, exitcode]=moselexec(..)
%
% Description
% Compile and run a Mosel program.
%
% Input Arguments
% srcfile   Name of the Mosel source file to run, can be any Mosel 
%           generalized file
% parlist   String composed of model parameter initializations separated by
%           commas
% options   Compilation options (documented in the Mosel Language Reference
%           Manual)
%
% Output Arguments
% retcode   Compilation and execution result code
%             <0 compilation failed 
%              0 program executed successfully  
%             >0 an error occured during model execution 
%           If this argument is omitted and execution is not successful, 
%           then a warning is printed.
% exitcode  Exit status returned by the Mosel program

% ---------------------------------------------------------------------------
% File: moselexec.m
% ---------------------------------------------------------------------------
% Published by Fair Isaac Corporation
% Copyright (C) Fair Isaac Corporation 2014-2025. All rights reserved.