/* *********************************************************************** *
 *                                                                         *
 * xpress_classes.hpp                                                      *
 *                                                                         *
 * C++ API for Xpress-Optimizer                                            *
 *                                                                         *
 * (c) Copyright Fair Isaac Corporation 2024-2025. All rights reserved     *
 * For FICO Xpress Optimizer v45.01.02                                     *
 *                                                                         *
 * *********************************************************************** */

#ifndef XPRESS_CLASSES_H
#define XPRESS_CLASSES_H 1
namespace xpress {
template <typename T> class ExtendableArray;
}
namespace xpress {
template <typename T> class ExtendableArrayImplementation;
}
namespace xpress {
class ExtendableDoubleArray;
}
namespace xpress {
class ExtendableDoubleArrayImplementation;
}
namespace xpress {
class ExtendableIntArray;
}
namespace xpress {
class ExtendableIntArrayImplementation;
}
namespace xpress {
class ExtendableTypeArray;
}
namespace xpress {
class ExtendableTypeArrayImplementation;
}
namespace xpress {
class IndicatorInfo;
}
namespace xpress {
class PwlBreakpoint;
}
namespace xpress {
class XPRSProblem;
}
namespace xpress {
namespace maps {
template <typename K1> class ComparableMapKey1;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2> class ComparableMapKey2;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3> class ComparableMapKey3;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3, typename K4>
class ComparableMapKey4;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3, typename K4, typename K5>
class ComparableMapKey5;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename V> class HashMap1;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename V> class HashMap2;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3, typename V> class HashMap3;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3, typename K4, typename V>
class HashMap4;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3, typename K4, typename K5,
          typename V>
class HashMap5;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1> class MapKey1;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2> class MapKey2;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3> class MapKey3;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3, typename K4> class MapKey4;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3, typename K4, typename K5>
class MapKey5;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename V> class TreeMap1;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename V> class TreeMap2;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3, typename V> class TreeMap3;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3, typename K4, typename V>
class TreeMap4;
}
} // namespace xpress
namespace xpress {
namespace maps {
template <typename K1, typename K2, typename K3, typename K4, typename K5,
          typename V>
class TreeMap5;
}
} // namespace xpress
namespace xpress {
namespace objects {
class AbstractExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class AbstractExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class BinaryExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class BinaryExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class ConstantExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class ConstantExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
template <typename C> class ConstraintDefinition;
}
} // namespace xpress
namespace xpress {
namespace objects {
template <typename C> class ConstraintDefinitionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class Expression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class ExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class FormulaExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class FormulaExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class GeneralConstraint;
}
} // namespace xpress
namespace xpress {
namespace objects {
class GeneralConstraintDefinition;
}
} // namespace xpress
namespace xpress {
namespace objects {
class GeneralConstraintDefinitionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class GeneralConstraintImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class IIS;
}
} // namespace xpress
namespace xpress {
namespace objects {
class IISConstraint;
}
} // namespace xpress
namespace xpress {
namespace objects {
class IISVariable;
}
} // namespace xpress
namespace xpress {
namespace objects {
class Index;
}
} // namespace xpress
namespace xpress {
namespace objects {
template <typename T> class IndexHandler;
}
} // namespace xpress
namespace xpress {
namespace objects {
class IndicatorDescription;
}
} // namespace xpress
namespace xpress {
namespace objects {
class IndicatorDescriptionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class IndicatorObjects;
}
} // namespace xpress
namespace xpress {
namespace objects {
class Inequality;
}
} // namespace xpress
namespace xpress {
namespace objects {
class InequalityDefinition;
}
} // namespace xpress
namespace xpress {
namespace objects {
class InequalityDefinitionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class InequalityImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class InternalFunctionExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class InternalFunctionExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class InternalUtils;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinCoef;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinExprProductView;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinQuadUtils;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinTerm;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinTermImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinTermList;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinTermListImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinTermMap;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinTermMapImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class LinearView;
}
} // namespace xpress
namespace xpress {
namespace objects {
class NotInProblemException;
}
} // namespace xpress
namespace xpress {
namespace objects {
class PWL;
}
} // namespace xpress
namespace xpress {
namespace objects {
class PWLDefinition;
}
} // namespace xpress
namespace xpress {
namespace objects {
class PWLDefinitionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class PWLExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class PWLExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class PWLImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class PostfixExtractor;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QPair;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QuadCoef;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QuadExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QuadExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QuadTerm;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QuadTermImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QuadTermList;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QuadTermListImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QuadTermMap;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QuadTermMapImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class QuadView;
}
} // namespace xpress
namespace xpress {
namespace objects {
class SOS;
}
} // namespace xpress
namespace xpress {
namespace objects {
class SOSDefinition;
}
} // namespace xpress
namespace xpress {
namespace objects {
class SOSDefinitionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class SOSImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class SumExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class SumExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class SymbolicEvalStack;
}
} // namespace xpress
namespace xpress {
namespace objects {
class Token;
}
} // namespace xpress
namespace xpress {
namespace objects {
class UnaryExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class UnaryExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class UserFunctionExpression;
}
} // namespace xpress
namespace xpress {
namespace objects {
class UserFunctionExpressionImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class Variable;
}
} // namespace xpress
namespace xpress {
namespace objects {
class VariableImplementation;
}
} // namespace xpress
namespace xpress {
namespace objects {
class WrappedIteratorImpl;
}
} // namespace xpress
namespace xpress {
namespace objects {
class XpressProblem;
}
} // namespace xpress
template <typename K1, typename K2>
struct std::hash<xpress::maps::MapKey2<K1, K2>> {
  inline std::size_t operator()(xpress::maps::MapKey2<K1, K2> const &arg) const;
};
template <typename K1, typename K2>
struct std::hash<xpress::maps::ComparableMapKey2<K1, K2>> {
  inline std::size_t
  operator()(xpress::maps::ComparableMapKey2<K1, K2> const &arg) const;
};
template <typename K1, typename K2, typename K3>
struct std::hash<xpress::maps::MapKey3<K1, K2, K3>> {
  inline std::size_t
  operator()(xpress::maps::MapKey3<K1, K2, K3> const &arg) const;
};
template <typename K1, typename K2, typename K3>
struct std::hash<xpress::maps::ComparableMapKey3<K1, K2, K3>> {
  inline std::size_t
  operator()(xpress::maps::ComparableMapKey3<K1, K2, K3> const &arg) const;
};
template <typename K1, typename K2, typename K3, typename K4>
struct std::hash<xpress::maps::MapKey4<K1, K2, K3, K4>> {
  inline std::size_t
  operator()(xpress::maps::MapKey4<K1, K2, K3, K4> const &arg) const;
};
template <typename K1, typename K2, typename K3, typename K4>
struct std::hash<xpress::maps::ComparableMapKey4<K1, K2, K3, K4>> {
  inline std::size_t
  operator()(xpress::maps::ComparableMapKey4<K1, K2, K3, K4> const &arg) const;
};
template <typename K1, typename K2, typename K3, typename K4, typename K5>
struct std::hash<xpress::maps::MapKey5<K1, K2, K3, K4, K5>> {
  inline std::size_t
  operator()(xpress::maps::MapKey5<K1, K2, K3, K4, K5> const &arg) const;
};
template <typename K1, typename K2, typename K3, typename K4, typename K5>
struct std::hash<xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5>> {
  inline std::size_t operator()(
      xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5> const &arg) const;
};
template <> struct std::hash<xpress::objects::QPair> {
  inline std::size_t operator()(xpress::objects::QPair const &arg) const;
};
template <> struct std::hash<xpress::PwlBreakpoint> {
  inline std::size_t operator()(xpress::PwlBreakpoint const &arg) const;
};
template <> struct std::hash<xpress::objects::GeneralConstraint> {
  inline std::size_t
  operator()(xpress::objects::GeneralConstraint const &arg) const;
};
template <> struct std::hash<xpress::objects::Inequality> {
  inline std::size_t operator()(xpress::objects::Inequality const &arg) const;
};
template <> struct std::hash<xpress::objects::PWL> {
  inline std::size_t operator()(xpress::objects::PWL const &arg) const;
};
template <> struct std::hash<xpress::objects::SOS> {
  inline std::size_t operator()(xpress::objects::SOS const &arg) const;
};
template <> struct std::hash<xpress::objects::Token> {
  inline std::size_t operator()(xpress::objects::Token const &arg) const;
};
template <> struct std::hash<xpress::objects::Variable> {
  inline std::size_t operator()(xpress::objects::Variable const &arg) const;
};
template <typename K1, typename K2>
struct std::less<xpress::maps::ComparableMapKey2<K1, K2>> {
  inline bool
  operator()(xpress::maps::ComparableMapKey2<K1, K2> const &a,
             xpress::maps::ComparableMapKey2<K1, K2> const &b) const;
};
template <typename K1, typename K2>
struct std::greater<xpress::maps::ComparableMapKey2<K1, K2>> {
  inline bool
  operator()(xpress::maps::ComparableMapKey2<K1, K2> const &a,
             xpress::maps::ComparableMapKey2<K1, K2> const &b) const;
};
template <typename K1, typename K2>
struct std::equal_to<xpress::maps::ComparableMapKey2<K1, K2>> {
  inline bool
  operator()(xpress::maps::ComparableMapKey2<K1, K2> const &a,
             xpress::maps::ComparableMapKey2<K1, K2> const &b) const;
};
template <typename K1, typename K2, typename K3>
struct std::less<xpress::maps::ComparableMapKey3<K1, K2, K3>> {
  inline bool
  operator()(xpress::maps::ComparableMapKey3<K1, K2, K3> const &a,
             xpress::maps::ComparableMapKey3<K1, K2, K3> const &b) const;
};
template <typename K1, typename K2, typename K3>
struct std::greater<xpress::maps::ComparableMapKey3<K1, K2, K3>> {
  inline bool
  operator()(xpress::maps::ComparableMapKey3<K1, K2, K3> const &a,
             xpress::maps::ComparableMapKey3<K1, K2, K3> const &b) const;
};
template <typename K1, typename K2, typename K3>
struct std::equal_to<xpress::maps::ComparableMapKey3<K1, K2, K3>> {
  inline bool
  operator()(xpress::maps::ComparableMapKey3<K1, K2, K3> const &a,
             xpress::maps::ComparableMapKey3<K1, K2, K3> const &b) const;
};
template <typename K1, typename K2, typename K3, typename K4>
struct std::less<xpress::maps::ComparableMapKey4<K1, K2, K3, K4>> {
  inline bool
  operator()(xpress::maps::ComparableMapKey4<K1, K2, K3, K4> const &a,
             xpress::maps::ComparableMapKey4<K1, K2, K3, K4> const &b) const;
};
template <typename K1, typename K2, typename K3, typename K4>
struct std::greater<xpress::maps::ComparableMapKey4<K1, K2, K3, K4>> {
  inline bool
  operator()(xpress::maps::ComparableMapKey4<K1, K2, K3, K4> const &a,
             xpress::maps::ComparableMapKey4<K1, K2, K3, K4> const &b) const;
};
template <typename K1, typename K2, typename K3, typename K4>
struct std::equal_to<xpress::maps::ComparableMapKey4<K1, K2, K3, K4>> {
  inline bool
  operator()(xpress::maps::ComparableMapKey4<K1, K2, K3, K4> const &a,
             xpress::maps::ComparableMapKey4<K1, K2, K3, K4> const &b) const;
};
template <typename K1, typename K2, typename K3, typename K4, typename K5>
struct std::less<xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5>> {
  inline bool operator()(
      xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5> const &a,
      xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5> const &b) const;
};
template <typename K1, typename K2, typename K3, typename K4, typename K5>
struct std::greater<xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5>> {
  inline bool operator()(
      xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5> const &a,
      xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5> const &b) const;
};
template <typename K1, typename K2, typename K3, typename K4, typename K5>
struct std::equal_to<xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5>> {
  inline bool operator()(
      xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5> const &a,
      xpress::maps::ComparableMapKey5<K1, K2, K3, K4, K5> const &b) const;
};
template <> struct std::less<xpress::objects::QPair> {
  inline bool operator()(xpress::objects::QPair const &a,
                         xpress::objects::QPair const &b) const;
};
template <> struct std::greater<xpress::objects::QPair> {
  inline bool operator()(xpress::objects::QPair const &a,
                         xpress::objects::QPair const &b) const;
};
template <> struct std::equal_to<xpress::objects::QPair> {
  inline bool operator()(xpress::objects::QPair const &a,
                         xpress::objects::QPair const &b) const;
};
template <> struct std::less<xpress::PwlBreakpoint> {
  inline bool operator()(xpress::PwlBreakpoint const &a,
                         xpress::PwlBreakpoint const &b) const;
};
template <> struct std::greater<xpress::PwlBreakpoint> {
  inline bool operator()(xpress::PwlBreakpoint const &a,
                         xpress::PwlBreakpoint const &b) const;
};
template <> struct std::equal_to<xpress::PwlBreakpoint> {
  inline bool operator()(xpress::PwlBreakpoint const &a,
                         xpress::PwlBreakpoint const &b) const;
};
template <> struct std::less<xpress::objects::GeneralConstraint> {
  inline bool operator()(xpress::objects::GeneralConstraint const &a,
                         xpress::objects::GeneralConstraint const &b) const;
};
template <> struct std::greater<xpress::objects::GeneralConstraint> {
  inline bool operator()(xpress::objects::GeneralConstraint const &a,
                         xpress::objects::GeneralConstraint const &b) const;
};
template <> struct std::equal_to<xpress::objects::GeneralConstraint> {
  inline bool operator()(xpress::objects::GeneralConstraint const &a,
                         xpress::objects::GeneralConstraint const &b) const;
};
template <> struct std::less<xpress::objects::Inequality> {
  inline bool operator()(xpress::objects::Inequality const &a,
                         xpress::objects::Inequality const &b) const;
};
template <> struct std::greater<xpress::objects::Inequality> {
  inline bool operator()(xpress::objects::Inequality const &a,
                         xpress::objects::Inequality const &b) const;
};
template <> struct std::equal_to<xpress::objects::Inequality> {
  inline bool operator()(xpress::objects::Inequality const &a,
                         xpress::objects::Inequality const &b) const;
};
template <> struct std::less<xpress::objects::PWL> {
  inline bool operator()(xpress::objects::PWL const &a,
                         xpress::objects::PWL const &b) const;
};
template <> struct std::greater<xpress::objects::PWL> {
  inline bool operator()(xpress::objects::PWL const &a,
                         xpress::objects::PWL const &b) const;
};
template <> struct std::equal_to<xpress::objects::PWL> {
  inline bool operator()(xpress::objects::PWL const &a,
                         xpress::objects::PWL const &b) const;
};
template <> struct std::less<xpress::objects::SOS> {
  inline bool operator()(xpress::objects::SOS const &a,
                         xpress::objects::SOS const &b) const;
};
template <> struct std::greater<xpress::objects::SOS> {
  inline bool operator()(xpress::objects::SOS const &a,
                         xpress::objects::SOS const &b) const;
};
template <> struct std::equal_to<xpress::objects::SOS> {
  inline bool operator()(xpress::objects::SOS const &a,
                         xpress::objects::SOS const &b) const;
};
template <> struct std::less<xpress::objects::Token> {
  inline bool operator()(xpress::objects::Token const &a,
                         xpress::objects::Token const &b) const;
};
template <> struct std::greater<xpress::objects::Token> {
  inline bool operator()(xpress::objects::Token const &a,
                         xpress::objects::Token const &b) const;
};
template <> struct std::equal_to<xpress::objects::Token> {
  inline bool operator()(xpress::objects::Token const &a,
                         xpress::objects::Token const &b) const;
};
template <> struct std::less<xpress::objects::Variable> {
  inline bool operator()(xpress::objects::Variable const &a,
                         xpress::objects::Variable const &b) const;
};
template <> struct std::greater<xpress::objects::Variable> {
  inline bool operator()(xpress::objects::Variable const &a,
                         xpress::objects::Variable const &b) const;
};
template <> struct std::equal_to<xpress::objects::Variable> {
  inline bool operator()(xpress::objects::Variable const &a,
                         xpress::objects::Variable const &b) const;
};
template <typename K1, typename K2>
struct std::equal_to<xpress::maps::MapKey2<K1, K2>> {
  inline bool operator()(xpress::maps::MapKey2<K1, K2> const &a,
                         xpress::maps::MapKey2<K1, K2> const &b) const;
};
template <typename K1, typename K2, typename K3>
struct std::equal_to<xpress::maps::MapKey3<K1, K2, K3>> {
  inline bool operator()(xpress::maps::MapKey3<K1, K2, K3> const &a,
                         xpress::maps::MapKey3<K1, K2, K3> const &b) const;
};
template <typename K1, typename K2, typename K3, typename K4>
struct std::equal_to<xpress::maps::MapKey4<K1, K2, K3, K4>> {
  inline bool operator()(xpress::maps::MapKey4<K1, K2, K3, K4> const &a,
                         xpress::maps::MapKey4<K1, K2, K3, K4> const &b) const;
};
template <typename K1, typename K2, typename K3, typename K4, typename K5>
struct std::equal_to<xpress::maps::MapKey5<K1, K2, K3, K4, K5>> {
  inline bool
  operator()(xpress::maps::MapKey5<K1, K2, K3, K4, K5> const &a,
             xpress::maps::MapKey5<K1, K2, K3, K4, K5> const &b) const;
};
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::BinaryExpression const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::ConstantExpression const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::Expression const &o);
inline std::ostream &
operator<<(std::ostream &os,
           xpress::objects::InternalFunctionExpression const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::LinTerm const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::LinTermList const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::LinTermMap const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::PWLExpression const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::QPair const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::QuadTerm const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::QuadTermList const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::QuadTermMap const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::SumExpression const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::Token const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::UnaryExpression const &o);
inline std::ostream &
operator<<(std::ostream &os, xpress::objects::UserFunctionExpression const &o);
inline std::ostream &operator<<(std::ostream &os,
                                xpress::objects::Variable const &o);
#endif
