// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * File : KWidestDomain.h                                           *
// * Description : SubClass of KVariableSelector                      *
// * looks for unassigned variable with smallest domain               *
// ********************************************************************

#ifndef __KWIDESTDOMAIN_H
#define __KWIDESTDOMAIN_H

#include "Globals.h"
#include "KNumVariableSelector.h"

/**
 * This class implements a variable selector that selects the first
 * uninstantiated variable with the widest domain.
 *
 * Example :
 * @code
 * KBranchingSchemeArray bsa;
 * bsa += KSplitNumDomain(KWidestDomain(), KMaxToMin();
 * @endcode
 *
 * @see KNumVariableSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KWidestDomain : public KNumVariableSelector {
  public:
    /// Default constructor
    KWidestDomain();
    /// Copy constructor
    KWidestDomain(const KWidestDomain& widestDomainToCopy);
    // Destructor
    virtual ~KWidestDomain();
    //methods
    // return the uninstantiated variable with the smallest domain
    virtual KNumVar * selectNextVariable(KNumVarArray* numVarArray);
    virtual KNumVariableSelector* getCopyPtr() const;
}; // class KWidestDomain

/**
 * Smallest domain variable selector
 */
class DLLIMPORTEXPORT KNumSmallestDomain : public KNumVariableSelector {
  public:
    /// Default constructor
    KNumSmallestDomain();
    /// Copy constructor
    KNumSmallestDomain(const KNumSmallestDomain& toCopy);
    // Destructor
    virtual ~KNumSmallestDomain();
    //methods
    // return the uninstantiated variable with the smallest domain
    virtual KNumVar * selectNextVariable(KNumVarArray* numVarArray);
    virtual KNumVariableSelector* getCopyPtr() const;
}; // class KNumSmallestDomain

#endif
