// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : class which is in charge of choosing a variable    *
// * following specific parameteres (used in KBranchingScheme (mainly *
// * KAssignVar))                                                     *
// ********************************************************************

#ifndef __KVARIABLESELECTOR_H
#define __KVARIABLESELECTOR_H

#include <iostream>

#include "Globals.h"
#include "kalis_compat.h"

/**
 * Abstract interface class for variable selection heuristic
 *
 * @see KSmallestDomain KMaxDegree KSmallestMin KSmallestMax KLargestMin
 *      KLargestMax KRandomVariable KSmallestDomDegRatio KMaxRegretOnLowerBound
 *      KMaxRegretOnUpperBound
 *
 * @since 2016.1
*/
class DLLIMPORTEXPORT KVariableSelector : public KExternalObject<KVariableSelector_I>, public KPtrArray<KVariableSelector> {
  private:
    KProblem* _problem;
  public:
    /// Constructor
    KVariableSelector();
    /// Constructor with KProblem
    KVariableSelector(KProblem* problem);
    /// Constructor with KVariableSelector_I*
    KVariableSelector(KVariableSelector_I* variableSelector, bool manage = true);
    /// Copy constructor
    KVariableSelector(const KVariableSelector& toCopy);
    // Destructor
    virtual ~KVariableSelector();
    KProblem* getProblem() const;
    //methods
    /** virtual interface method to overload for definition of your own variable selection heuristics
    @param intVarArray Array of variable from wich selecting  a variable
    */
    virtual KIntVar * selectNextVariable(KIntVarArray* intVarArray);
    virtual double getVariableRank(KIntVar * varToRank,double &best,KIntVar * &varResult,bool first);
    virtual KVariableSelector* getCopyPtr() const;
    virtual KVariableSelector* getInstanceCopyPtr(const KProblem& problem) const;
    virtual void printName() const {
      std::cout << "KVariableSelector" << std::endl;
    }
    virtual const char* getName() const {
        return "KVariableSelector";
    }
}; // class KVariableSelector

EXTTEMPL template class DLLIMPORTEXPORT KPtrArray<KVariableSelector>;

#endif
