// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : class which is in charge of founding the order in  *
// * which value will be tested during Branch and Bound               *
// ********************************************************************

#ifndef __KVALUESELECTOR_H
#define __KVALUESELECTOR_H

#include <iostream>

#include "Globals.h"
#include "kalis_compat.h"

/**
 * Abstract interface class for value selection heuristic
 *
 * @see KMaxToMin KMinToMax KMiddle KRandomValue KNearestValue
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KValueSelector : public KExternalObject<KValueSelector_I>, public KPtrArray<KValueSelector> {
  private:
    KProblem* _problem;
  public:
    /// Constructor
    KValueSelector();
    /// Constructor with KProblem
    KValueSelector(KProblem* problem);
    // Internal use
    KValueSelector(KValueSelector_I* valueSelector, bool manage = true);
    /// Copy constructor
    KValueSelector(const KValueSelector& toCopy);
    // Destructor
    virtual ~KValueSelector();
    /// Return the current problem
    KProblem* getProblem() const;

    /**
     * Virtual method to overload with your own value selection heuristic.
     *
     * @param intVar the variable to selects a value for
     */
    virtual int selectNextValue(KIntVar* intVar);
    
    virtual KValueSelector* getCopyPtr() const;
    virtual KValueSelector* getInstanceCopyPtr(const KProblem& problem) const;
    virtual void printName() const {
      std::cout << "VALUE_SELECTOR" << std::endl;
    }
    virtual const char * getName() const {
        return "VALUE_SELECTOR";
    }
}; // class KValueSelector

EXTTEMPL template class DLLIMPORTEXPORT KPtrArray<KValueSelector>;

#endif
