// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : array of tuples                                    *
// ********************************************************************

#ifndef __KTUPLEARRAY_H
#define __KTUPLEARRAY_H

#include "Globals.h"
#include "ArtelysList.h"
#include "KIntArray.h"

EXTTEMPL template class DLLIMPORTEXPORT ArtelysList<KIntArray>;

/**
 * This class implements an array of tuples of fixed arity
 *
 * Example :
 * @code
 * KTupleArray tupleArray(3);
 * KIntArray tuple(3, 1, 2, 3);
 * tupleArray += tuple;
 * // tupleArray = { (1,2,3) }
 * tuple[0] = 3;
 * tuple[2] = 2;
 * tuple[3] = 1;
 * // tupleArray = { (1,2,3), (3,2,1) }
 * @endcode
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KTupleArray : public ArtelysList<KIntArray> {
  public :
    // default constructor
    KTupleArray();
    // destructor
    virtual ~KTupleArray();
    // methods
    // Addition assignment operator overload
    KTupleArray& operator+= (const KIntArray&);
    virtual ArtelysList<KIntArray>* getCopyPtr() const;
    void print() const;
};

#endif
