
// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : represent objects created by the methods creating  *
// * constraints                                                      *
// ********************************************************************

#ifndef __KTERM_H
#define __KTERM_H

#include <iostream>

#include "Globals.h"
#include "kalis_compat.h"

/**
 * Superclass of KUnTerm and KBinTerm
 */
class DLLIMPORTEXPORT KTerm {
  protected:
    // An integer constant
    double _cste;
  public:
    /// Default constructor
    KTerm();
    /// Main constructor
    KTerm(double cste);
    /// Copy constructor
    KTerm(const KTerm &termToCopy);
    /// Destructor
    virtual ~KTerm();
    /// Get method
    double getCste() const;
    /// Set the constant
    void setCste(const double cste);
    /// pretty print method
    virtual void print() const;
    virtual void print(void * ctx,PrintFunctionPtr*pfp) const;
    /// overloaded operator =
    const KTerm &operator=(const KTerm &termToCopy);
 private:
    virtual void print(std::ostream & fout) const;
}; // class KTerm

#endif
