// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KTASKARRAY_H
#define __KTASKARRAY_H

#include "Globals.h"
#include "ArtelysList.h"
#include "KTask.h"

#ifdef WIN32
#pragma warning(disable:4231)
#endif

EXTTEMPL template class DLLIMPORTEXPORT ArtelysList<KTask>;

/**
 * This class implements an array of KTask
 *
 * Example :
 * @code
 * KSchedule  s(...);
 *
 * // T is an array of KTask T0 T1 T2 T3 T4
 * KTaskArray T(s,5,0,10,"T");
 * @endcode
 *
 * @see KIntVar
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KTaskArray : public ArtelysList<KTask> {
  public:
    /// default constructor
    KTaskArray();
    /// This constructor allows to build an array of variables with the same bounds
    KTaskArray(KSchedule & schedule, int nbTask, const char*name=nullptr);
    // Internal use
    virtual int check(KTask_I *_ptr) const;
    // destructor
    ~KTaskArray();
};

#endif
