// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : user class representing a CSP solution             *
// ********************************************************************

#ifndef __KSOLUTION_H
#define __KSOLUTION_H

#include "Globals.h"
#include "KSolver.h"
#include "kalis_compat.h"

/**
 * This class represents a solution of a KProblem.
 *
 * Example :
 * @code
 * KProblem p(...);
 * KSolver solver(p);
 * solver.solve();
 * KSolution sol = p.getSolution();
 * @endcode
 *
 * @see KProblem
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KSolution : public KAutoExternalObject<KSolution, KSolution_I> {
  public:
    /// Constructor
    KSolution();
    // Constructor with KSolution_I*
    KSolution(KSolution_I* solution);
    // Copy constructor
    KSolution(const KSolution &toCopy);
    // Destructor
    virtual ~KSolution();
    KSolution * getCopyPtr() const;
    KSolution& operator=(const KSolution& toCopy);
    /// Return the instantiation of a variable in the solution
    int getValue(KIntVar& intVar) const;
    /// Return the instantiation of a variable in the solution
    double getValue(KFloatVar& floatVar) const;
    /// Return the instantiation of the variable in the solution
    double getValue(KNumVar& numVar) const;

    /// Return the objective value of the solution if applicable
    double getObjectiveValue() const;
    void setAsTarget(void);
    /// Pretty print the solution
    virtual void print() const;
    virtual void print(void* ctx, PrintFunctionPtr* pfp) const;
    void printResume(void* ctx, PrintFunctionPtr* pfp) const;
    void printResume() const;
    void printProblem() const;
    // attributes
    int  getIntAttrib(KSolver::IntAttrib attrib);
    double getDblAttrib(KSolver::DblAttrib attrib);
    bool hasObjective(void) const;
    double getHashCode();
}; // class KSolution

#endif
