// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// * looks for unassigned variable with smallest upper bound in domain*
// ********************************************************************

#ifndef __KSMALLESTMAX_H
#define __KSMALLESTMAX_H

#include "Globals.h"
#include "KVariableSelector.h"

/**
 * This class implements a variable selector that selects first the variable
 * with the smallest upperbound.
 *
 * Example:
 * @code
 * KBranchingSchemeArray bsa;
 * bsa += KAssignVar(KSmallestMax(), KMaxToMin();
 * @endcode
 *
 * @see KVariableSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KSmallestMax : public KVariableSelector {
  public:
    /// Constructor
    KSmallestMax();
    /// Copy constructor
    KSmallestMax(const KSmallestMax& toCopy);
    // Destructor
    virtual ~KSmallestMax();
    //methods
    virtual KVariableSelector* getCopyPtr() const;
}; // class SmallestMax

#endif
