// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// * looks for unassigned variable with smallest domain               *
// ********************************************************************

#ifndef __KSMALLESTDOMAIN_H
#define __KSMALLESTDOMAIN_H

#include "Globals.h"
#include "KVariableSelector.h"

/**
 * This class implements a variable selector that selects the first uninstantiated variable with the smallest domain.
 *
 * Example :
 * @code
 * KBranchingSchemeArray bsa;
 * bsa += KAssignVar(KSmallestDomain(),KMaxToMin();
 * @endcode
 *
 * @see KVariableSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KSmallestDomain : public KVariableSelector {
  public:
    /// Default constructor
    KSmallestDomain();
    /// Copy constructor
    KSmallestDomain(const KSmallestDomain& smallestDomainToCopy);
    // Destructor
    virtual ~KSmallestDomain();
    //methods
    virtual KVariableSelector* getCopyPtr() const;
}; // class KSmallestDomain

#endif
