// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// * looks for unassigned variable with smallest ratio (dom / degree) *
// ********************************************************************

#ifndef __KSMALLESTDOMDEGRATIO_H
#define __KSMALLESTDOMDEGRATIO_H

#include "Globals.h"
#include "KVariableSelector.h"

/**
 * This class implements a variable selector that selects first the variable with the smallest ratio domain size / degree in the constraint graph.
 *
 * Example :
 * @code
 * KBranchingSchemeArray myBranchingSchemeArray;
 * myBranchingSchemeArray += KAssignVar(KSmallestDomDegRatio(),KMaxToMin();
 * @endcode
 *
 * @see KVariableSelector
 *
 * @since 2016.1
*/
class DLLIMPORTEXPORT KSmallestDomDegRatio : public KVariableSelector {
  public:
    /// Constructor
    KSmallestDomDegRatio();
    /// Copy constructor
    KSmallestDomDegRatio(const KSmallestDomDegRatio& smallestDomDegRatioToCopy);
    // Destructor
    virtual ~KSmallestDomDegRatio();
    //methods
    virtual KVariableSelector* getCopyPtr() const;
}; // class KSmallestDomDegRatio

#endif
