// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KSETTLEDISJUNCTION_H
#define __KSETTLEDISJUNCTION_H

#include "Globals.h"
#include "KBranchingScheme.h"
#include "kalis_compat.h"

/**
 * KSettleDisjunction branching scheme
 *
 * \image html SettleDisjunction.png
 *
 * Example :
 * @code
 * KBranchingSchemeArray myBranchingSchemeArray;
 * myBranchingSchemeArray += KSettleDisjunction();
 * @endcode
 *
 * @see KBranchingScheme KAssignVar KAssignAndForbid KSettleDisjunction KProbe KSplitDomain
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KSettleDisjunction : public KBranchingScheme {
   public:
    /// Primary constructor
    KSettleDisjunction(KDisjunctionSelector* disjunctionSelector = nullptr);
    /**
     Constructor
     @param disjunctionArray the disjunction array to branch on
    */
    KSettleDisjunction(const KDisjunctionArray& disjunctionArray, KDisjunctionSelector* disjunctionSelector = nullptr);
    // Constructor with KSettleDisjunction_I*
    KSettleDisjunction(KSettleDisjunction_I* settleDisjunction);
    // Copy constructor
    KSettleDisjunction(const KSettleDisjunction& toCopy);
    // Destructor
    virtual ~KSettleDisjunction();
    virtual KBranchingScheme* getCopyPtr() const;
    virtual KBranchingScheme* getInstanceCopyPtr(const KProblem& problem) const;
};  // class KSettleDisjunction

#endif
