// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KRESOURCEARRAY_H
#define __KRESOURCEARRAY_H

#include "Globals.h"
#include "ArtelysList.h"
#include "KResource.h"

#ifdef WIN32
#  pragma warning(disable:4231)
#endif

EXTTEMPL template class DLLIMPORTEXPORT ArtelysList<KResource>;
EXTTEMPL template class DLLIMPORTEXPORT ArtelysList<KResourceUsage>;

/**
 * This class implements an array of KResource
 *
 * Example :
 * @code
 * KSchedule  s(...);
 *
 * // R is an array of KResource R0 R1 R2 R3 R4
 * KResourceArray R(s,5,0,10,"T");
 * @endcode
 *
 * @see KResource
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KResourceArray : public ArtelysList<KResource> {
  public:
    /// default constructor
    KResourceArray();
    /// This constructor allows to build an array of variables with the same bounds
    KResourceArray(KSchedule & schedule, int nbResource, const char*name=nullptr);
    virtual int check(KResource_I *_ptr) const;
    // destructor
    ~KResourceArray();
};

#endif
