// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * File : KRandomVariable.h                                         *
// * Description : SubClass of KVariableSelector                      *
// * looks for unassigned variable at random                          *
// ********************************************************************

#ifndef __KRANDOMVARIABLE_H
#define __KRANDOMVARIABLE_H

#include "Globals.h"
#include "KVariableSelector.h"

/**
 * This class implements a variable selector that selects an uninstantiated
 * variable at random.
 *
 * Example :
 * @code
 * KBranchingSchemeArray myBranchingSchemeArray;
 * myBranchingSchemeArray += KAssignVar(KRandomVariable(),KMaxToMin();
 * @endcode
 *
 * @see KVariableSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KRandomVariable : public KVariableSelector {
  public:
    // Constructors
    KRandomVariable();
    // Copy constructor
    KRandomVariable(const KRandomVariable& toCopy);
    // Destructor
    virtual ~KRandomVariable();
    //methods
    virtual KVariableSelector* getCopyPtr() const;
}; // class KRandomVariable

#endif
