// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KValueSelector                         *
// * looks for a random value in the domain                           *
// ********************************************************************

#ifndef __KRANDOMVALUE_H
#define __KRANDOMVALUE_H

#include "Globals.h"
#include "KValueSelector.h"

/**
 * This class implements a value selector that selects a value at random in the domain of the variable.
 *
 * Example :
 * @code
 * KBranchingSchemeArray bsa;
 * bsa += KAssignVar(KSmallestDomain(),KRandomValue());
 * @endcode
 *
 * @see KValueSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KRandomValue : public KValueSelector {
  public:
    // Constructors
    KRandomValue();
    // Copy constructor
    KRandomValue(const KRandomValue& toCopy);
    // Destructor
    virtual ~KRandomValue();
    //methods
    virtual int selectNextValue(KIntVar* intVar); // get Next Value
    virtual KValueSelector* getCopyPtr() const;
};

#endif
