// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : class implementing a parallel branching scheme     *
// * allows splitting search work between several solvers             *
// ********************************************************************

#ifndef __KPARALLELBRANCHINGSCHEME_H
#define __KPARALLELBRANCHINGSCHEME_H

#include "Globals.h"
#include "KBranchingScheme.h"
#include "kalis_compat.h"

/**
 * Parallel branching scheme
 *
 * Example:
 * @code
 * KBranchingSchemeArray bsa;
 * bsa += KParallelBranchingScheme(KSplitDomain(KSmallestDomain(), KMaxToMin()));
 * @endcode
 *
 * @see KBranchingScheme KAssignVar KAssignAndForbid KSettleDisjunction KProbe KSplitDomain
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KParallelBranchingScheme : public KBranchingScheme {
  public:
    /**
     * Constructor
     *
     * @param branchingScheme internal branching scheme used for parallel branching among multiple workers
     */
    KParallelBranchingScheme(const KBranchingSchemeArray& branchingSchemeArray, int maxDepth);
    // Constructor with KSplitDomain_I*
    KParallelBranchingScheme(KParallelBranchingScheme_I* parallelBranchingScheme);
    // Copy constructor
    KParallelBranchingScheme(const KParallelBranchingScheme& toCopy);
    // Destructor
    virtual ~KParallelBranchingScheme();
    // Methods
    virtual KBranchingScheme* getCopyPtr() const;
    virtual KBranchingScheme* getInstanceCopyPtr(const KProblem& problem) const;
}; // class KParallelBranchingScheme

#endif
