// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : defined operators on Artelys Kalis objects         *
// ********************************************************************

#ifndef __KOPERATORS_H
#define __KOPERATORS_H

#include "Globals.h"

#define FASTCALL

// ********************************************************************
//
//              Operators returning an KUnTerm object
//
// ********************************************************************

KUnTerm  DLLIMPORTEXPORT FASTCALL operator+( const KUnTerm &left,  double right);
KUnTerm  DLLIMPORTEXPORT FASTCALL operator+( double left,  const  KUnTerm &right);
KUnTerm  DLLIMPORTEXPORT FASTCALL operator+( const  KNumVar &left,  double right);
KUnTerm  DLLIMPORTEXPORT FASTCALL operator+( double left,  const KNumVar &right);
KUnTerm  DLLIMPORTEXPORT FASTCALL operator-( const KUnTerm &right);
KUnTerm  DLLIMPORTEXPORT FASTCALL operator-( const  KNumVar &left,  double right);
KUnTerm  DLLIMPORTEXPORT FASTCALL operator-( const KUnTerm &left,  double right);
KUnTerm  DLLIMPORTEXPORT FASTCALL operator-( double left,  const KNumVar &right);
KUnTerm  DLLIMPORTEXPORT FASTCALL operator-( double right, const KUnTerm &left);
KUnTerm  DLLIMPORTEXPORT FASTCALL operator-( const KNumVar &right);

// ********************************************************************
//
//              Operators returning a KBdoubleerm object
//
// ********************************************************************

KBinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KNumVar &left,  const KNumVar &right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KUnTerm &left,  const KNumVar &right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KNumVar &left,  const KUnTerm &right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KUnTerm &left,  const KUnTerm &right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KBinTerm &left,  double right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator+( double left,  const KBinTerm &right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KBinTerm &right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KBinTerm &left,  double right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KNumVar &left,  const KNumVar &right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KUnTerm &left,  const KNumVar &right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KNumVar &left,  const KUnTerm &right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KUnTerm &left,  const KUnTerm &right);
KBinTerm  DLLIMPORTEXPORT FASTCALL operator-( double left,  const KBinTerm &right);

// ********************************************************************
//
//				Operators returning a KNonLinearTerm object
//
// ********************************************************************
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(const KNumVar &left, const KNumVar &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(const KNonLinearTerm&left, const  KNumVar &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(const KNumVar&left, const  KNonLinearTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(const KNonLinearTerm&left, double right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(double left, const KNonLinearTerm&right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(const KNumVar &left, const KLinTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(const KLinTerm &left, const KNumVar &right);
template<typename TLeft, typename TRight>
KNonLinearTerm mulOperator(TLeft& left, TRight& right);
template<typename TLeft>
KNonLinearTerm powIntOperator(TLeft & left, int right);
template<typename TLeft, typename TRight>
KNonLinearTerm powOperator(TLeft & left, double right);
template<typename TRight>
KNonLinearTerm addRightOperator(KNonLinearTerm& left, TRight& right, const int OPERATOR);
template<typename TLeft>
KNonLinearTerm addLeftOperator(TLeft& left, KNonLinearTerm& right, const int OPERATOR);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(const KLinTerm &left, const KLinTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(const KNonLinearTerm &left, const KLinTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(const KLinTerm &left, const KNonLinearTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator*(const KNonLinearTerm &left, const KNonLinearTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator^(const KNumVar &left, int right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator^(const KLinTerm &left, int right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator^(const KNonLinearTerm &left, int right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator^(const KNumVar &left, double right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator^(const KLinTerm &left, double right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator^(const KNonLinearTerm &left, double right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator+(const KNonLinearTerm &left, double right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator+(const KNonLinearTerm &left, const KNumVar &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator+(const KNonLinearTerm &left, const KLinTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator+(const KNonLinearTerm &left, const KNonLinearTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator+(double left, const KNonLinearTerm &right); 
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator+(const KNumVar &left, const KNonLinearTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator+(const KLinTerm &left, const KNonLinearTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator-(const KNonLinearTerm &left, double right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator-(const KNonLinearTerm &left, const KNumVar &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator-(const KNonLinearTerm &left, const KLinTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator-(const KNonLinearTerm &left, const KNonLinearTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator-(double left, const KNonLinearTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator-(const KNumVar &left, const KNonLinearTerm &right);
KNonLinearTerm DLLIMPORTEXPORT FASTCALL operator-(const KLinTerm &left, const KNonLinearTerm &right);


// ********************************************************************
//
//				Operators returning a KLinTerm object
//
// ********************************************************************

KLinTerm  DLLIMPORTEXPORT FASTCALL operator*( double left,  const KNumVar &right);
//KNumLinTerm  DLLIMPORTEXPORT FASTCALL operator*( double left,  const KNumVar &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator*( const KNumVar &left,  double right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator*( const KLinTerm &left,  double right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator/( const KLinTerm &left,  double right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator*( double left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KBinTerm &left,  const KNumVar &right);
//KNumLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KNumBinTerm &left,  const KNumVar &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KNumVar &left,  const KBinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KBinTerm &left,  const KUnTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KUnTerm &left,  const KBinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KBinTerm &left,   const KBinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KLinTerm &left,  double right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( double left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KLinTerm &left,  const KNumVar &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KNumVar &left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KLinTerm &left,  const KUnTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KUnTerm &left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KLinTerm &left,  const KBinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KBinTerm &left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator+( const KLinTerm &left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KLinTerm &left,  double right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KBinTerm &left,  const KNumVar &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KLinTerm &left,  const KNumVar &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KLinTerm &left,  const KUnTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KNumVar &left,  const KBinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KUnTerm &left,  const KBinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KBinTerm &left,  const KBinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KLinTerm &left,  const KBinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( double left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KNumVar &left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KUnTerm &left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KBinTerm &left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KLinTerm &left,  const KLinTerm &right);
KLinTerm  DLLIMPORTEXPORT FASTCALL operator-( const KBinTerm &left,  const KUnTerm &right);

// ********************************************************************
//
//				Returning an KEqualXc / KNumEqualXc object object
//
// ********************************************************************

KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const  KNumVar &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( double left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KUnTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( double left,  const  KUnTerm &right);

// ********************************************************************
//
//				Returning a KLessOrEqualXc / KNumLessOrEqualXc object
//
// ********************************************************************

KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const  KNumVar &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const  KNumVar &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( double left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( double left,  const KNumVar &right);

// ********************************************************************
//
//				Returning a KGreaterOrEqualXc / KNumGreaterOrEqualXc object
//
// ********************************************************************

KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const  KNumVar &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const  KNumVar &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( double left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( double left,  const KNumVar &right);

// ********************************************************************
//
//					Returning a KNotEqualXc object
//
// ********************************************************************

KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const  KNumVar &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( double left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KUnTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( double left,  const  KUnTerm &right);

// ********************************************************************
//
//				Returning a KGreaterOrEqualXyc object
//
// ********************************************************************

KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KNumVar &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KNumVar &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KNumVar &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KNumVar &left,  const KNumVar &right);

// ********************************************************************
//
//				Returning a KNotEqualXyc object
//
// ********************************************************************

KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KNumVar &left,  const KNumVar &right);

// ********************************************************************
//
//					Returning an KEqualXyc object
//
// ********************************************************************

KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KNumVar &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KUnTerm &left,  const KUnTerm &right);

// ********************************************************************
//
//					Returning a KNumLinComb object
//
// ********************************************************************

KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KLinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KLinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KLinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KLinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KLinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KBinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KBinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KBinTerm &left,  const KNumVar &right); //!! for KXEqualYMinusZ constraint
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KNumVar &left,  const KBinTerm &right); //!! for KXEqualYMinusZ constraint
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( double left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KNumVar &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KUnTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KUnTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KBinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KLinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KLinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KLinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KLinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KLinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( double left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KNumVar &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KBinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KBinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KBinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KNumVar &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KUnTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KUnTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KBinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( double left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KNumVar &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KNumVar &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KLinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KBinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KLinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KBinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KLinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KUnTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KBinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KLinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KUnTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KBinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KLinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( double left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KNumVar &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KNumVar &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KLinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KBinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KLinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KBinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KLinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KUnTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KBinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KLinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KUnTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KBinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KLinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( double left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KNumVar &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KNumVar &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KLinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KBinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KLinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KBinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KLinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KUnTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KBinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KLinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KUnTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KBinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KLinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KBinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KBinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KBinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KLinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KLinTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KLinTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KLinTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KLinTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KNumVar &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KUnTerm &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( double left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KNumVar &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KUnTerm &left,  const KLinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KBinTerm &left,  const KLinTerm &right);

// *****************************************************************
//
//				Operators returning a KNumNonLinearComb
//
// *****************************************************************

KConstraint DLLIMPORTEXPORT FASTCALL operator==(const KNonLinearTerm &left, const KNonLinearTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator==(const KNonLinearTerm &left, const KLinTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator==(const KLinTerm &left, const KNonLinearTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator==(const KNumVar &left, const KNonLinearTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator==(const KNonLinearTerm &left, const KNumVar &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator==(const KNonLinearTerm &left, double right);
KConstraint DLLIMPORTEXPORT FASTCALL operator>=(const KNonLinearTerm &left, const KNonLinearTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator>=(const KNonLinearTerm &left, const KLinTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator>=(const KLinTerm &left, const KNonLinearTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator>=(const KNumVar &left, const KNonLinearTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator>=(const KNonLinearTerm &left, const KNumVar &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator>=(const KNonLinearTerm &left, double right);
KConstraint DLLIMPORTEXPORT FASTCALL operator<=(const KNonLinearTerm &left, const KNonLinearTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator<=(const KNonLinearTerm &left, const KLinTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator<=(const KLinTerm &left, const KNonLinearTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator<=(const KNumVar &left, const KNonLinearTerm &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator<=(const KNonLinearTerm &left, const KNumVar &right);
KConstraint DLLIMPORTEXPORT FASTCALL operator<=(const KNonLinearTerm &left, double right);

// ********************************************************************
//
//				Returning an KConstraint object
//
// ********************************************************************

KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KUnTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KBinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( double left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator==( const KNumVar &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KUnTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KBinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( double &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KUnTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>=( const KNumVar &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( double &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KNumVar &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KBinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KUnTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator>( const KUnTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( double &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KNumVar &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KBinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KUnTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<=( const KUnTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( double &left,  const KBinTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KNumVar &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KBinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KUnTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator<( const KUnTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KUnTerm &left,  const KNumVar &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KUnTerm &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KBinTerm &left,  double right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( const KNumVar &left,  const KUnTerm &right);
KConstraint  DLLIMPORTEXPORT FASTCALL operator!=( double left,  const KBinTerm &right);

// ********************************************************************
//
//						Returning an KOccurrence
//
// ********************************************************************

KOccurrence  DLLIMPORTEXPORT FASTCALL operator==( const KNumVar &left, const KOccurTerm &right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator==( const KOccurTerm &left,  const KNumVar &right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator==( const KOccurTerm &left,  double right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator==( double left, const KOccurTerm &right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator>=( const KNumVar &left, const KOccurTerm &right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator>=( double left, const KOccurTerm &right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator>=( const KOccurTerm &left,  const KNumVar &right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator>=( const KOccurTerm &left,  double right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator<=( const KNumVar &left, const KOccurTerm &right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator<=( double left, const KOccurTerm &right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator<=( const KOccurTerm &left,  const KNumVar &right);
KOccurrence  DLLIMPORTEXPORT FASTCALL operator<=( const KOccurTerm &left,  double right);

// ********************************************************************
//
//						Returning an KElement
//
// ********************************************************************

KElement  DLLIMPORTEXPORT FASTCALL operator==( const KEltTerm &e,  const KNumVar &x);
KElement  DLLIMPORTEXPORT FASTCALL operator==( const KNumVar &x,  const KEltTerm &e);
KElement  DLLIMPORTEXPORT FASTCALL operator==( const KEltTerm &e,  double x);
KElement  DLLIMPORTEXPORT FASTCALL operator==( double x, const KEltTerm &e);

// ********************************************************************
//
//						Returning a KConjunction
//
// ********************************************************************

KConjunction  DLLIMPORTEXPORT FASTCALL operator&&( const class KConstraint &c1, const class KConstraint &c2);

// ********************************************************************
//
//						Returning a KDisjunction
//
// ********************************************************************

KDisjunction  DLLIMPORTEXPORT FASTCALL operator||( const class KConstraint &c1, const class KConstraint &c2);

#endif
