// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KNUMVARARRAY_H
#define __KNUMVARARRAY_H

#include "Globals.h"
#include "ArtelysList.h"

EXTTEMPL template class DLLIMPORTEXPORT ArtelysList<KNumVar>;

/**
 * This class implements an array of KNumVar.
 *
 * Example :
 * @code
 * KProblem  p(...);
 * KNumVarArray T;
 * T += KIntVar(p, "X");
 * @endcode
 *
 * @see KIntVar
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KNumVarArray : public ArtelysList<KNumVar> {
  public:
    /// default constructor
    KNumVarArray();
    // Addition assignment operator overload
    KNumVarArray& operator+= (const KNumVar&);
    virtual int check(KNumVar_I * var) const;
    // destructor
    ~KNumVarArray();
};

#endif
