// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : class which is in charge of founding the order in  *
// * which value will be tested during Branch and Bound               *
// ********************************************************************

#ifndef __KNUMVALUESELECTOR_H
#define __KNUMVALUESELECTOR_H

#include <iostream>

#include "Globals.h"
#include "kalis_compat.h"

/**
 * Abstract interface class for value selection heuristic
 * @see KMaxToMin KMinToMax KMiddle KRandomValue KNearestValue
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KNumValueSelector : public KExternalObject<KNumValueSelector_I>, public KPtrArray<KNumValueSelector> {
  private:
    KProblem* _problem;
  public:
    /// Constructor
    KNumValueSelector();
    /// Constructor with KProblem
    KNumValueSelector(KProblem* problem);
    /// Constructor with KNumValueSelector_I*
    KNumValueSelector(KNumValueSelector_I* numValueSelector, bool manage = true);
    /// Copy constructor
    KNumValueSelector(const KNumValueSelector& toCopy);
    // Destructor
    virtual ~KNumValueSelector();
    KProblem* getProblem() const;
    //methods
    /** virtual method to overload with your own value selection heuristic
    @param intVar the variable to selects a value for
    */
    virtual double selectNextValue(KNumVar* intVar);
    virtual KNumValueSelector* getCopyPtr() const;
    virtual KNumValueSelector* getInstanceCopyPtr(const KProblem& problem) const;
    virtual void printName() const {
      std::cout << "VALUE_SELECTOR" << std::endl;
    }
    virtual const char * getName() const {
        return "VALUE_SELECTOR";
    }
}; // class KNumValueSelector

EXTTEMPL template class DLLIMPORTEXPORT KPtrArray<KNumValueSelector>;

#endif
