// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KNONLINTERM_H
#define __KNONLINTERM_H

#include <iostream>

#include "Globals.h"
#include "KTerm.h"
#include "kalis_compat.h"

class KHybridSolution;

/**
 * This class represent a non linear term.
 *
 * Example :
 * @code
 *	X + 3 * Y ^ 3
 * @endcode
 *
 * @see KConstraint KNumLinComb
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KNonLinearTerm : public KTerm {
  private :
    static int nbtmpvars;
    bool manageVar;
  public:
    KNumVar * var;
    KLinTerm * linTerm;
    int fct;
    int op;
    int exp;
    enum CompareOperator {GEQ,GT,LEQ,LT,EQ};
    enum AlgebricOperator {OP_NONE,OP_PLUS,OP_MINUS,OP_MULT,OP_DIV};
    enum NonLinFunction {FCT_NONE,FCT_LN,FCT_EXPONENTIAL,FCT_EXP,FCT_COS,FCT_SIN,FCT_TAN,FCT_ACOS,FCT_ASIN,FCT_ATAN,FCT_COSH,FCT_SINH,FCT_TANH,FCT_ABS};
    KNonLinearTerm *left,*right;
    KNonLinearTerm();
    KNonLinearTerm(double cste);
    KNonLinearTerm( KNonLinearTerm *LEFT, KNonLinearTerm *RIGHT,const int OPERATOR);
    KNonLinearTerm( KLinTerm *X);
    KNonLinearTerm( KNumVar *X);
    KNonLinearTerm( KNonLinearTerm *LEFT,int FCT);
    KNonLinearTerm( KNonLinearTerm *LEFT,int EXP,const int FCT);
    KNonLinearTerm(const KNonLinearTerm& toCopy, int pb);
    KNonLinearTerm(const KNonLinearTerm& toCopy);
    void operator=(const KNonLinearTerm &toAssign);
    KNonLinearTerm * getCopyPtr() const;
    ~KNonLinearTerm();
    virtual void print(std::ostream & fout) const;
    virtual void print() const;
    virtual void print(void * ctx,PrintFunctionPtr*pfp) const;
    void postNonLinearEpression(KProblem * prob);
    /// returns the KProblem associated with this variable
    KProblem * getProblem() const;
};

#endif
