// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KValueSelector                         *
// * rounds the relaxed value                                         *
// ********************************************************************

#ifndef __KNEARESTRELAXEDVALUE_H
#define __KNEARESTRELAXEDVALUE_H

#include "Globals.h"
#include "KValueSelector.h"
#include "kalis_compat.h"

/**
 * This value selector chooses the value closest to the relaxed solution
 * contained in the provided solver.
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KNearestRelaxedValue : public KValueSelector {
  public:
    /// Constructor.
    KNearestRelaxedValue(KLinearRelaxationSolver*);
    /// Copy constructor.
    KNearestRelaxedValue(const KNearestRelaxedValue& toCopy);
    /// Destructor.
    virtual ~KNearestRelaxedValue();
    /// get Next Value
    int selectNextValue(KIntVar* intVar);
    // Internal use
    virtual KValueSelector* getCopyPtr() const;
    // Internal use
    virtual const char* getName() const {
        return "NEAREST_RELAXED_VALUE";
    }
};

#endif
