// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// * looks for variable whose relaxed value is the most fractional    *
// ********************************************************************

#ifndef __KMOSTFRACTIONAL_H
#define __KMOSTFRACTIONAL_H

#include "Globals.h"
#include "KVariableSelector.h"
#include "kalis_compat.h"

/**
 * This variable selector selects the variable with biggest fractional part in
 * the current solution held by the provided linear relaxation solver.
 *
 * Note that it does NOT call the "solve" method of the solver, so if you want
 * the relaxation to be re-solved at each node, you must use method
 * KSolver::setOtherNodesRelaxationSolver.
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KMostFractional : public KVariableSelector {
  public:
    /// Constructor
    KMostFractional(KLinearRelaxationSolver*);
    /// Copy constructor
    KMostFractional(const KMostFractional& toCopy);
    /// Destructor
    virtual ~KMostFractional();
    // Internal use
    virtual KVariableSelector* getCopyPtr() const;
};

#endif
