// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KValueSelector                         *
// * looks for next value in decreasing order                         *
// ********************************************************************

#ifndef __KMINTOMAX_H
#define __KMINTOMAX_H

#include "Globals.h"
#include "KValueSelector.h"

/**
 * This class implements a value selector that returns values in increasing
 * order.
 *
 * Example :
 * @code
 * KBranchingSchemeArray myBranchingSchemeArray;
 * myBranchingSchemeArray += KAssignVar(KSmallestDomain(),KMinToMax());
 * @endcode
 *
 * @see KValueSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KMinToMax : public KValueSelector {
  public:
    /// Constructor
    KMinToMax();
    /// Copy constructor
    KMinToMax(const KMinToMax& toCopy);
    // Destructor
    virtual ~KMinToMax();
    //methods
    /// get Next Value
    virtual int selectNextValue(KIntVar* intVar);
    virtual KValueSelector* getCopyPtr() const;
    virtual const char * getName() const {
        return "MIN_TO_MAX";
    }
}; // class KMinToMax

#endif

