// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KValueSelector                         *
// * looks for next value in decreasing order                         *
// ********************************************************************

#ifndef __KMAXTOMIN_H
#define __KMAXTOMIN_H

#include "Globals.h"
#include "KValueSelector.h"



/**
 * This class implements a value selector that returns values in decreasing
 * order.
 *
 * Example :
 * @code
 * KBranchingSchemeArray bsa;
 * bsa += KAssignVar(KSmallestDomain(), KMaxToMin();
 * @endcode
 *
 * @see KValueSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KMaxToMin : public KValueSelector {
  public:
    /// Default Constructor
    KMaxToMin();
    /// Copy constructor
    KMaxToMin(const KMaxToMin& maxToMinToCopy);
    // Destructor
    virtual ~KMaxToMin();
    //methods
    /// get Next Value
    virtual int selectNextValue(KIntVar* intVar);
    virtual KValueSelector* getCopyPtr() const;
    virtual const char * getName() const {
        return "MAX_TO_MIN";
    }
}; // class KMaxToMin

#endif
