// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// * looks for unassigned variable with largest difference between the*
// * largest and second largest value in the domain                   *
// ********************************************************************

#ifndef __KMAXREGRETONUPPERBOUND_H
#define __KMAXREGRETONUPPERBOUND_H

#include "Globals.h"
#include "KVariableSelector.h"

/**
 * This class implements a variable selector that selects first the variable
 * with maximum regret on its upperbound.
 *
 * Example :
 * @code
 * KBranchingSchemeArray bsa;
 * bsa += KAssignVar(KMaxRegretOnUpperBound(), KMaxToMin();
 * @endcode
 *
 * @see KVariableSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KMaxRegretOnUpperBound : public KVariableSelector {
  public:
    /// Constructor
    KMaxRegretOnUpperBound();
    /// Copy constructor
    KMaxRegretOnUpperBound(const KMaxRegretOnUpperBound& maxRegretOnUpperBoundToCopy);
    // Destructor
    virtual ~KMaxRegretOnUpperBound();
    //methods
    virtual KVariableSelector* getCopyPtr() const;
}; // class KMaxRegretOnUpperBound

#endif
