// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// * looks for unassigned variable with largest difference between the*
// * smallest and second smallest value in the domain                 *
// ********************************************************************

#ifndef __KMAXREGRETONLOWERBOUND_H
#define __KMAXREGRETONLOWERBOUND_H

#include "Globals.h"
#include "KVariableSelector.h"

/**
 * This class implements a variable selector that selects first the variable with maximum regret on its lowerbound.
 *
 * Example :
 * @code
 * KBranchingSchemeArray bsa;
 * bsa += KAssignVar(KMaxRegretOnLowerBound(), KMaxToMin();
 * @endcode
 *
 * @see KVariableSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KMaxRegretOnLowerBound : public KVariableSelector {
  public:
    /// Constructor
    KMaxRegretOnLowerBound();
    /// Copy constructor
    KMaxRegretOnLowerBound(const KMaxRegretOnLowerBound& maxRegretOnLowerBoundToCopy);
    // Destructor
    virtual ~KMaxRegretOnLowerBound();
    //methods
    virtual KVariableSelector* getCopyPtr() const;
}; // class KMaxRegretOnLowerBound

#endif
