// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// * looks for unassigned variable with the largest degree            *
// ********************************************************************

#ifndef __KMAXDEGREE_H
#define __KMAXDEGREE_H

#include "Globals.h"
#include "KVariableSelector.h"

/**
 * This class implements a variable selector that selects first the variable
 * involved in the maximum number of constraints.
 *
 * Example :
 * @code
 * KBranchingSchemeArray myBranchingSchemeArray;
 * myBranchingSchemeArray += KAssignVar(KMaxDegree(),KMaxToMin();
 * @endcode
 *
 * @see KVariableSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KMaxDegree : public KVariableSelector {
  public:
    /// Constructor
    KMaxDegree();
    /// Copy constructor
    KMaxDegree(const KMaxDegree& maxDegreeToCopy);
    // Destructor
    virtual ~KMaxDegree();
    // Pointer copy
    virtual KVariableSelector* getCopyPtr() const;
}; // class KMaxDegree

#endif
