// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// * looks for variable with largest reduced cost in LP relaxation    *
// ********************************************************************

#ifndef __KLARGESTREDUCEDCOST_H
#define __KLARGESTREDUCEDCOST_H

#include "Globals.h"
#include "KVariableSelector.h"
#include "KNumVariableSelector.h"
#include "kalis_compat.h"

/**
 * This variable selector selects the variable with biggest reduced cost in current LP solution
 * of the provided linear relaxation solver.
 *
 * Note that it does NOT call the solve() method of the solver automatically.
 * The current LP solution is simply read as it is.
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KLargestReducedCost : public KVariableSelector {
  public:
    /// Constructor
    KLargestReducedCost(KLinearRelaxationSolver*);
    /// Copy constructor
    KLargestReducedCost(const KLargestReducedCost& toCopy);
    /// Destructor
    virtual ~KLargestReducedCost();
    // Internal use
    virtual KVariableSelector* getCopyPtr() const;
};

/**
 * This variable selector selects the variable with biggest reduced cost in
 * current LP solution of the provided linear relaxation solver.
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KNumLargestReducedCost : public KNumVariableSelector {
  public:
    /// Constructor
    KNumLargestReducedCost(KLinearRelaxationSolver*);
    /// Copy constructor
    KNumLargestReducedCost(const KNumLargestReducedCost& toCopy);
    /// Destructor
    virtual ~KNumLargestReducedCost();
    // Internal use
    virtual KNumVariableSelector* getCopyPtr() const;
};

#endif
