// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// * looks for unassigned variable with largest lower bound on domain *
// ********************************************************************

#ifndef __KLARGESTMIN_H
#define __KLARGESTMIN_H

#include "Globals.h"
#include "KVariableSelector.h"

/**
 * This class implements a variable selector that selects first the variable
 * with the largest lower bound.
 *
 * Example:
 * @code
 * KBranchingSchemeArray myBranchingSchemeArray;
 * myBranchingSchemeArray += KAssignVar(KLargestMin(), KMaxToMin();
 * @endcode
 *
 * @see KVariableSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KLargestMin : public KVariableSelector {
  public:
    // Constructors
    KLargestMin();
    // Copy constructor
    KLargestMin(const KLargestMin& smallestDomainToCopy);
    // Destructor
    virtual ~KLargestMin();
    //methods
    virtual KVariableSelector* getCopyPtr() const;
}; // class KLargestMin

#endif
