// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// * looks for unassigned variable with smallest domain               *
// ********************************************************************

#ifndef __KLARGESTMAX_H
#define __KLARGESTMAX_H

#include "Globals.h"
#include "KVariableSelector.h"

/**
 * This class implements a variable selector that selects first the variable
 * with the largest upperbound in its domain.
 *
 * Example:
 * @code
 * KBranchingSchemeArray myBranchingSchemeArray;
 * myBranchingSchemeArray += KAssignVar(KLargestMax(), KMaxToMin();
 * @endcode
 *
 * @see KVariableSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KLargestMax : public KVariableSelector {
  public:
    /// Default Constructor
    KLargestMax();
    /// Copy constructor
    KLargestMax(const KLargestMax& toCopy);
    // Destructor
    virtual ~KLargestMax();
    //methods
    virtual KVariableSelector* getCopyPtr() const;
}; // class KLargestMax

#endif

