// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KINTERVALDOMAIN_H
#define __KINTERVALDOMAIN_H

#include "Globals.h"
#include "KBranchingScheme.h"
#include "kalis_compat.h"

/**
 * Branching scheme for splitting float variables into a set of intervals.
 *
 * This branching scheme split the domain of a float variable into interval
 * of length `gap`. If the boolean `order` is false, then interval are
 * created in ascending order (descending order otherwise).
 *
 * For an initial domain [l, u], the created sub-domains will be:
 *     - In ascending order: [l + (k-1) * gap, min(l + k * gap, u)] for k=1,...,ceil((u-l)/gap)
 *     - In descending order: [u - k * gap, max(u - (k-1) * gap, l)] for k=1,...,ceil((u-l)/gap)
 *
 * @see KBranchingScheme
 */
class DLLIMPORTEXPORT KIntervalDomain : public KBranchingScheme {
   public:
    /// Constructor
    KIntervalDomain(const KNumVarArray& floatVarArray, double gap, bool order);
    // Internal use only
    KIntervalDomain(KIntervalDomain_I* intervalDomain);
    // Destructor
    virtual ~KIntervalDomain();
    // Internal use only
    virtual KBranchingScheme* getCopyPtr() const;
    // Internal use only
    virtual KBranchingScheme* getInstanceCopyPtr(const KProblem& problem) const;
};  // class KIntervalDomain

#endif
