// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : array of int                                       *
// ********************************************************************

#ifndef __KINTARRAY_H
#define __KINTARRAY_H

#include "Globals.h"
#include "ArtelysValList.h"

EXTTEMPL template class DLLIMPORTEXPORT ArtelysValList<int>;

/**
 * This class implements an array of integers
 *
 * Example :
 * @code
 * KIntArray intArray;
 * intArray += 3;
 * intArray += 5;
 * // intArray = { 3,5 }
 * intArray[0] = 2;
 * // intArray = { 2,5 }
 * @endcode
 *
 * @see  KDoubleArray
 * @since 2016.1
 */
class DLLIMPORTEXPORT KIntArray : public ArtelysValList<int> {
   public:
    // constructors
    KIntArray();
    KIntArray(int nbElements, ...);
    // destructor
    virtual ~KIntArray();
    // methods
    virtual ArtelysValList<int>* getCopyPtr() const;
    KIntArray& operator+=(const int&);
    void print() const;
};  // class KIntArray

#endif
