// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KGACTABLECONSTRAINT_H
#define __KGACTABLECONSTRAINT_H

#include "Globals.h"
#include "KConstraint.h"

/**
 * This class implements a generic class for propagation of any n-ary constraint by generalized arc consistency \\
 *
 * @see KGeneralizedArcConsistencyConstraint KConstraint
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KGeneralizedArcConsistencyTableConstraint : public KConstraint {
  public :
    /** Constructor.
      This constructor takes three arguments
      @param vars is the list of variables in the table constraint
      @param tuples is the list of tuples allowed by the constraint
      @param name label for pretty printing of the constraint
    */
    KGeneralizedArcConsistencyTableConstraint(KIntVarArray &vars, KTupleArray &tuples, const char * name=0);
    /// Copy Constructor
    KGeneralizedArcConsistencyTableConstraint(const KGeneralizedArcConsistencyTableConstraint &toCopy);
    ~KGeneralizedArcConsistencyTableConstraint();
};

#endif
