// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KGACCONSTRAINT_H
#define __KGACCONSTRAINT_H

#include <iostream>

#include "Globals.h"
#include "KConstraint.h"

/**
 * This class implements a generic class for propagation of any nary constraint by forward checking/arc consistency or generalized arc consistency
 *
 * @see KConstraint
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KGeneralizedArcConsistencyConstraint : public KConstraint {
  public :
    /**
     * This constructor takes threee arguments
     *
     * @param vars an array of variables
     * @param acAlgorithm GENERALIZED_ARC_CONSISTENCY (default value) for propagation by the generalized arc consistency algorithm, ARC_CONSISTENCY for propagation by the AC algorithm, FORWARD_CHECKING for propagatino by the forward checking algorithm
     * @param name label for pretty printing of the constraint
     */
   KGeneralizedArcConsistencyConstraint(KIntVarArray& vars, int acAlgorithm = GENERALIZED_ARC_CONSISTENCY,
                                        const char* name = 0);
   /// Copy Constructor
   KGeneralizedArcConsistencyConstraint(const KGeneralizedArcConsistencyConstraint& toCopy);
   /// Destructor
   virtual ~KGeneralizedArcConsistencyConstraint();
   // Internal use
   virtual KConstraint* getInstance(unsigned int pb) const;
   /**
    * Abstract Interface for generic propagation of any binary constraint.
    *
    * @return true if and only if the constraint is satisfied when v1 == val1 & v2 == val2
    */
   virtual bool testIfSatisfied(const std::vector<int>& tuple);  // return true if the constraint holds
   /// Pretty printing of the constraint
   virtual void print(std::ostream& fout) const;
   virtual void print(void) const;
   virtual void print(void* ctx, PrintFunctionPtr* pfp) const;
   /// Possible propagation algorithms
   enum acAlgorithms { GENERALIZED_ARC_CONSISTENCY, ARC_CONSISTENCY, FORWARD_CHECKING };
};

#endif
