// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : SubClass of KVariableSelector                      *
// ********************************************************************

#ifndef __KFLOATVARSELECTOR_H
#define __KFLOATVARSELECTOR_H

#include "Globals.h"
#include "KVariableSelector.h"

/**
 * Float variable selector
 *
 * @see KVariableSelector
 */
class DLLIMPORTEXPORT KFloatVarSelector : public KVariableSelector {
  public :
    /// Constructor
    KFloatVarSelector();
    /// Copy constructor
    KFloatVarSelector(const KFloatVarSelector& floatvarselectorToCopy);
    // Destructor
    virtual ~KFloatVarSelector();
    //methods
    virtual KFloatVar* selectNextVariable(KNumVarArray* floatVarArray, double gap); // get Next Variable
    virtual KVariableSelector* getCopyPtr() const;
}; // class KFloatVarSelector

#endif
