// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KLINEARRELAXATIONSOLVERBILEVEL_H
#define __KLINEARRELAXATIONSOLVERBILEVEL_H

#include "Globals.h"
#include "KProblem.h"
#include "KNumVarArray.h"
#include "KLinearRelaxationSolver.h"
#include "KLinearRelaxationSolverConfigurator.h"
#include "KIntVarArray.h"
#include "kalis_compat.h"

/*Bilevel relaxation solver*/
class DLLIMPORTEXPORT KBiLevelLinearRelaxationSolverConfigurator : public KLinearRelaxationSolverConfigurator {
  private :
    KBiLevelLinearRelaxationSolverConfigurator();
  public:
    KBiLevelLinearRelaxationSolverConfigurator(KProblem &problem);
    KBiLevelLinearRelaxationSolverConfigurator(const KNumVarArray &varArray);
    virtual ~KBiLevelLinearRelaxationSolverConfigurator();
};

/*Top node relaxation solver*/
class DLLIMPORTEXPORT KTopNodeLinearRelaxationSolverConfigurator : public KLinearRelaxationSolverConfigurator {
  public:
    KTopNodeLinearRelaxationSolverConfigurator(KProblem &problem);
    //KTopNodeLinearRelaxationSolverConfigurator(KSolver *solver);
    virtual ~KTopNodeLinearRelaxationSolverConfigurator();
};

/*Other node relaxation solver*/
class DLLIMPORTEXPORT KOtherNodeLinearRelaxationSolverConfigurator : public KLinearRelaxationSolverConfigurator {
  public:
    KOtherNodeLinearRelaxationSolverConfigurator(KProblem &problem);
    virtual ~KOtherNodeLinearRelaxationSolverConfigurator();
};

#endif
