// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KCONSTRAINT_H
#define __KCONSTRAINT_H

#include "Globals.h"
#include "KLinearRelaxation.h"

/**
 * This class is an abstract interface for all constraints in Artelys Kalis
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KConstraint : public KPtrArray<KConstraint> {
  protected :
    void * _constraintIPtr;
    KProblem * _problem;
  public :
    KConstraint();
    KConstraint(KProblem * problem);
    KConstraint(const KConstraint & toCopy);
    virtual ~KConstraint();
    KConstraint& operator=(const KConstraint& toCopy);
    virtual KConstraint* getCopyPtr() const;
    virtual KConstraint* getInstanceCopyPtr(const KProblem& problem) const;
    virtual KConstraint* getInstance(unsigned int pb) const;
    KProblem* getProblem() const;
    virtual void print(void) const;
    virtual void print(void * ctx,PrintFunctionPtr*pfp) const;
    virtual int getTypeInfo(void);
    void setName(const char*);
    virtual const char* getName() const;
    virtual int getArity();
    virtual int getTag();
    virtual void setTag(int _tag);
    int getPriority();
    void setPriority(int priorite);
#ifdef ACK_LIB
    void setHidden(bool hidden);
    bool isHidden();
    void setConstraintIPtr(void * cstr);
    void * getConstraintIPtr() const;
#endif
    bool isGetLinearRelaxationImplemented();
    KLinearRelaxation * getLinearRelaxation (int strategy = 0);
    int askIfEntailed(void);
};

EXTTEMPL template class DLLIMPORTEXPORT KPtrArray<KConstraint>;

#endif
