// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KBRANCHINGSCHEMEGROUP_H
#define __KBRANCHINGSCHEMEGROUP_H

#include <iostream>

#include "KBranchingSchemeArray.h"
#include "kalis_compat.h"


/**
 * A branching scheme group represents a list of branching schemes to use nested
 * branching schemes.
 *
 * @see KBranchingSchemeGroupSerializer KBranchingSchemeGroupArray
 */
class DLLIMPORTEXPORT KBranchingSchemeGroup {
  protected :
    KBranchingSchemeArray  _branchings;
    int _tag;
  public :
    KBranchingSchemeGroup(KBranchingSchemeArray & branchings,int tag=0);
    KBranchingSchemeGroup(const KBranchingSchemeGroup & toCopy);
    virtual ~KBranchingSchemeGroup();
    KBranchingSchemeArray & getBranchings();
    virtual KBranchingSchemeGroup* getCopyPtr() const;
    bool isFixed();
    int getTag();

    /**
     * Pretty printing of the task with a PrintFunctionPtr
     */
    virtual void print(std::ostream & fout) const;
    virtual void print(void * ctx,PrintFunctionPtr*pfp) const;
    virtual void print() const;
    void setSolver_I_ptr(KSolver_I * solver_I);
    double getPriority();
};

EXTTEMPL template class DLLIMPORTEXPORT ArtelysList<KBranchingSchemeGroup>;

/**
 * List of brancing scheme group.
 */
class DLLIMPORTEXPORT KBranchingSchemeGroupArray : public ArtelysList<KBranchingSchemeGroup> {

  public:
    // Constructors
    KBranchingSchemeGroupArray();
    // destructor
    ~KBranchingSchemeGroupArray();

}; // class KBranchingSchemeGroupArray : public ArtelysList<KBranchingScheme>

/**
 * Selection object to choose among a list of branching scheme group.
 *
 * @see KBranchingSchemeGroup KBranchingSchemeGroupSerializer KBranchingSchemeGroupArray
 */
class DLLIMPORTEXPORT KBranchingSchemeGroupSelector {
  public:

    KBranchingSchemeGroupSelector();
    KBranchingSchemeGroupSelector(const KBranchingSchemeGroupSelector& selectorToCopy);
    virtual ~KBranchingSchemeGroupSelector();
    virtual KBranchingSchemeGroup * selectNextGroup(KBranchingSchemeGroupArray* taskArray);
    virtual KBranchingSchemeGroupSelector* getCopyPtr() const;
    virtual void printName() const {
      std::cout << "BranchingSchemeGroupSelector" << std::endl;
    }
    virtual const char * getName() const {
        return "BranchingSchemeGroupSelector";
    }

}; // class KBranchingSchemeGroupSelector

/**
 * A nested branching scheme.
 *
 * \image groupSerializer.png
 *
 * From a list of branching scheme groups, this brancing scheme apply
 * iteratively each group.
 *
 * The default group selector uses input order.
 *
 * @see KTaskSerializer KBranchingSchemeGroup KBranchingSchemeGroupSelector
 */
class DLLIMPORTEXPORT KBranchingSchemeGroupSerializer : public KBranchingScheme {
  public:

    /// Primary constructor
    KBranchingSchemeGroupSerializer(const KBranchingSchemeGroupArray & groups,int discrepancyLimit=MAX_INT,KBranchingSchemeGroupSelector * groupSelector = nullptr);
    /// Constructor with KBranchingSchemeGroupSerializer_I*
    KBranchingSchemeGroupSerializer(KBranchingSchemeGroupSerializer_I* branchingSchemeGroupSerializer);
    /// Copy constructor
    KBranchingSchemeGroupSerializer(const KBranchingSchemeGroupSerializer & taskSerializer);
    /// Destructor
    virtual ~KBranchingSchemeGroupSerializer();
    /// Get a copy pointer
    virtual KBranchingScheme* getCopyPtr() const;
    virtual KBranchingScheme* getInstanceCopyPtr(const KProblem& problem) const;
};

#endif
