// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * File : KBranchingSchemeArray.h                                   *
// * Description : array of branching schemes                         *
// ********************************************************************

#ifndef __KBRANCHINGSCHEMEARRAY_H
#define __KBRANCHINGSCHEMEARRAY_H

#include "Globals.h"
#include "ArtelysList.h"
#include "KBranchingScheme.h"

EXTTEMPL template class DLLIMPORTEXPORT ArtelysList<KBranchingScheme>;

/**
 * This class implements an array of KBranchingScheme
 *
 * Example :
 * @code
 * KBranchingSchemeArray myStrategy;
 *
 * // First solve all the disjunctions in the problem
 * myStrategy += KSettleDisjunction();
 * // then assign each remaining non bound variable by assigning values in
 * // decreasing order to variables ordered by increasing size of domain
 * myStrategy += KAssignVar(KSmallestDomain(),KMaxToMin());
 *
 * @endcode
 *
 * @see KBranchingScheme KValueSelector KVariableSelector
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KBranchingSchemeArray : public ArtelysList<KBranchingScheme> {
  public:
    // Constructors
    KBranchingSchemeArray();

    // destructor
    ~KBranchingSchemeArray();

    // Addition assignment operator overload
    KBranchingSchemeArray& operator+= (const KBranchingScheme&);

}; // class KBranchingSchemeArray : public ArtelysList<KBranchingScheme>

#endif
