// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : class implementing a branching scheme looking for  *
// * a variable and making one branch for each value of the variable  *
// ********************************************************************

#ifndef __KASSIGNVAR_H
#define __KASSIGNVAR_H

#include "kalis_compat.h"

/**
 * AssignVar Branching scheme
 *
 * \image html AssignVar.png
 *
 * Example:
 * @code
 * KBranchingSchemeArray myBranchingSchemeArray;
 * myBranchingSchemeArray += KAssignVar(KSmallestDomain(), KMaxToMin());
 * @endcode
 *
 * @see KBranchingScheme KAssignVar KAssignAndForbid KSettleDisjunction KProbe KSplitDomain
 *
 * @since 2016.1
 */
class  DLLIMPORTEXPORT KAssignVar : public KBranchingScheme  {
  public:

    // Constructors
    KAssignVar();
    /** Constructor
        @param varSel the variable selector
    */
    KAssignVar(const KVariableSelector& vs);
    /** Constructor
        @param varSel the variable selector
    	@param valSel the value selector
    */
    KAssignVar(const KVariableSelector& varSel, const KValueSelector& valSel);
    /** Constructor
        @param varSel the variable selector
    	@param valSel the value selector
    	@param intVarArray the array of variable to assign value
    */
    KAssignVar(const KVariableSelector& varSel, const KValueSelector& valSel, const KIntVarArray& intVarArray);

    // Constructor with KAssignVar_I*
    KAssignVar(KAssignVar_I* assignVar);

    // Copy constructor
    KAssignVar(const KAssignVar& assignVarToCopy);

    // Destructor
    virtual ~KAssignVar();

    // Internal use
    virtual KBranchingScheme* getCopyPtr() const;
    // Internal use
    virtual KBranchingScheme* getInstanceCopyPtr(const KProblem& problem) const;
}; // class KAssignVar

#endif
