// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : class implementing a branching scheme looking      *
// * for a variable V and a value X.                                  *
// * Makes one branch where the V = X and another one where V != X    *
// ********************************************************************

#ifndef __KASSIGNANDFORBID_H
#define __KASSIGNANDFORBID_H

#include "KBranchingScheme.h"
#include "kalis_compat.h"

/**
 * Assign And Forbid branching scheme
 *
 * Example :
 * @code
 * KBranchingSchemeArray myBranchingSchemeArray;
 * myBranchingSchemeArray += KAssignAndForbid(KSmallestDomain(),KMaxToMin());
 * @endcode
 *
 * @see KBranchingScheme KAssignVar KAssignAndForbid KSettleDisjunction KProbe KSplitDomain
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KAssignAndForbid : public KBranchingScheme {
   public:
    /// Default Constructor
    KAssignAndForbid(const int discrepancyLimit = MAX_INT);
    /**
     * Constructor
     *
     * @param vs the variable selector
     */
    KAssignAndForbid(const KVariableSelector& vs, const int discrepancyLimit = MAX_INT);
    /**
     * Constructor
     *
     * @param vs the variable selector
     * @param valS the value selector
     */
    KAssignAndForbid(const KVariableSelector& vs, const KValueSelector& valS, const int discrepancyLimit = MAX_INT);
    /**
     * Constructor
     *
     * @param vs the variable selector
     * @param valS the value selector
     * @param intVarArray the array of variable to assign value
     */
    KAssignAndForbid(const KVariableSelector& vs, const KValueSelector& valS, const KIntVarArray& intVarArray,
                     const int discrepancyLimit = MAX_INT);
    /// Constructor with KAssignAndForbid_I*
    KAssignAndForbid(KAssignAndForbid_I* assignAndForbid);
    // Copy constructor
    KAssignAndForbid(const KAssignAndForbid& toCopy);
    // Destructor
    virtual ~KAssignAndForbid();

    // Methods
    virtual KBranchingScheme* getCopyPtr() const;
    virtual KBranchingScheme* getInstanceCopyPtr(const KProblem& problem) const;
};  // class KAssignAndForbid

#endif

