// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// ********************************************************************

#ifndef __KABS_H
#define __KABS_H

#include "Globals.h"
#include "KConstraint.h"

/**
 * This class creates a X = abs(Y) constraint
 *
 * Example :
 * @code
 * KIntVar X(...);
 * KIntVar Y(...);
 * ...
 * problem.post(KAbs("X=|Y|",X,Y));
 * ...
 * @endcode
 *
 * @see  KConstraint
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT KAbs : public KConstraint {
   public:
    /**
     * This constructor takes threee arguments
     *
     * @param name label for pretty printing of the constraint
     * @param X the 'X' variable of the constraint
     * @param Y the 'Y" variable of the constraint
     */
    KAbs(const char* name, KIntVar& X, KIntVar& Y);

    /** Constructor.
     * This constructor takes threee arguments
     *
     * @param name label for pretty printing of the constraint
     * @param X the 'X' variable of the constraint
     * @param Y the 'Y" variable of the constraint
     */
    KAbs(const char* name, KNumVar& X, KNumVar& Y);
    /// Copy Constructor
    KAbs(const KAbs& toCopy);

    virtual ~KAbs();

    /// Propagation level of the constraint
    enum PropagationLevel { BOUND_CONSISTENCY, ARC_CONSISTENCY };
};

#endif // __KABS_H__
