// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved.                                             *
// *                                                                  *
// * DO NOT EDIT THIS FILE.                                           *
// *                                                                  *
// * File : Globals.h                                                 *
// ********************************************************************

#ifdef DEBUG
#  ifndef _DEBUG
#    define _DEBUG
#  endif
#endif

#ifndef __GLOBALS_H
#define __GLOBALS_H

#ifdef WIN32
#  pragma warning(disable:4530)
#  pragma warning(disable:4786)
#  pragma warning(disable:4096)
#  pragma warning(disable:4661)
#  pragma warning(disable:4231)
#  pragma warning(disable:4101)
#  pragma warning(disable:4251)
#  pragma warning(disable:4231)
#  pragma warning(disable:4244)
#  pragma warning(disable:4018)
#endif

#include <cstdio>
#include <cstdlib>
#include <limits>
#include <cmath>

#include <assert.h>
#include <time.h>
#include <string.h>

#ifdef linux
#  ifndef LINUX
#    define LINUX
#  endif
#endif

#ifdef __APPLE__
#  ifndef APPLE
#    define APPLE
#  endif
#endif

#ifdef WIN32
#  if __cplusplus > 199711L
#    include <cmath>
#    define FINITE std::isfinite
#  else
#    define FINITE _finite
#  endif
#  ifndef INFINITY
#    define INFINITY (std::numeric_limits<double>::infinity())
#  endif
#endif

#ifdef LINUX
#  if __cplusplus > 199711L
#    define FINITE std::isfinite
#  else
#    define FINITE finite
#  endif
#endif

#ifdef APPLE
#  if __cplusplus > 199711L
#    define FINITE std::isfinite
#  else
#    include <AvailabilityMacros.h>
#    if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_9
#      define FINITE finite
#    else
#      define FINITE finite
#    endif
#  endif
#endif

#define DOUBLE_MAX std::numeric_limits<double>::max()
#define DOUBLE_MIN std::numeric_limits<double>::min()

#include <forward_list>
#include <map>
#include <set>
#include <vector>

using namespace std;

#ifdef KALIS_STATIC_LIB
#  ifndef DLLIMPORTEXPORT
#    define DLLIMPORTEXPORT
#  endif
#  ifndef EXTTEMPL
#    define EXTTEMPL
#  endif
#endif

#ifndef KALIS_STATIC_LIB
#  ifdef WIN32
#    ifndef DLLIMPORTEXPORT
#      ifdef ACK_EXPORTS
#        define DLLIMPORTEXPORT __declspec(dllexport)
#      else
#        define DLLIMPORTEXPORT __declspec(dllimport)
#      endif
#    endif
#    ifndef EXTTEMPL
#      ifdef ACK_EXPORTS
#        define EXTTEMPL
#      else
#        define EXTTEMPL extern
#      endif
#    endif
#  else
#    ifndef DLLIMPORTEXPORT
#      define DLLIMPORTEXPORT
#    endif
#    ifndef EXTTEMPL
#      define EXTTEMPL
#    endif
#  endif
#endif

#define MIN_INT                                -500000
#define MAX_INT                                 500000
#define ARTELYS_LIST_DEFAULTSIZE                10
#define NO_VALUE_GIVEN_TO_CONTROL_OR_ATTRIBUTE -1
#define MAX_DOUBLE                              1e+20
#define MIN_DOMAIN_SIZE_FOR_SPLIT_DOMAIN        5
#define FLOAT_VAR_INITIAL_DEFAULT_PRECISION     1e-6f
#define BACKTRACKABLE_INTERVAL_REL_TOL          1e-2f
#define BACKTRACKABLE_INTERVAL_ABS_TOL          1e-2f

#define AWAKE_PRIORITY   0
#define INST_PRIORITY    1
#define REMVAL_PRIORITY  2
#define BOUND_PRIORITY   3
#define PROP_PRIORITY    4
#define GLOBAL_PRIORITY  5

/*************************************************/
/*  >> Type definitions                          */
/*************************************************/

class AbstractObject;
class AbstractBinIntVarConstraint;
class AbstractConstraint;
class AbstractEvent;
class AbstractEventList;
class AbstractIntDomain;
class AbstractIntVarConstraint;
class AbstractKIntVar_IEvent;
class AbstractLargeIntVarConstraint;
class AbstractLargeNumVarConstraint;
class AbstractNumVarConstraint;
class AbstractPropagationEngine;
class AbstractVariable;
class AwakeEvent;
class BitVector;
class BoundDomain;
class Console;
class Contradiction;
class IntSetDomain;
class NumVar_InfRaisedEvent;
class NumVar_InstantiateEvent;
class IntVar_RemovalEvent;
class NumVar_SupLoweredEvent;
class KAbs;
class KAbs_I;
class KAC2001BinConstraint_I;
class KAC2001BinTableConstraint;
class KAC2001BinTableConstraint_I;
class KAC3BinConstraint_I;
class KAC3BinTableConstraint;
class KAC3BinTableConstraint_I;
class KACBinConstraint;
class KGeneralizedArcConsistencyConstraint;
class KGeneralizedArcConsistencyTableConstraint;
class KalisPropagationEngine;
class KAllDifferent;
class KAllDifferent_I;
class KAssignAndForbid_I;
class KAssignVar_I;
class KBinTerm;
class KBranchingComponent_I;
class KBranchingComponent_IArray;
class KBranchingScheme;
class KBranchingScheme_I;
class KBranchingSchemeGroupArray;
class KBranchingSchemeGroupSerializer_I;
class KBranchingSchemeArray;
class KConjunction;
class KConjunction_I;
class KConstraint;
class KConstraintArray;
class KDisjunction;
class KDisjunction_I;
class KDisjunctionArray;
class KDisjunctionSelector;
class KDisjunctionInputOrder;
class KDisjunctionPriorityOrder;
class KDistanceLowerThanXyc;
class KDistanceLowerThanXyc_I;
class KDoubleArray;
class KElement;
class KElement2D;
class KElement2D_I;
class KEltTerm;
class KEltTerm2D;
class KEqualXc;
class KEqualXc_I;
class KEqualXyc;
class KEqualXyc_I;
class KNumEqualXc;
class KNumEqualXc_I;
class KNumEqualXYc;
class KNumEqualXYc_I;
class KNumGreaterOrEqualXc;
class KNumGreaterOrEqualXc_I;
class KNumGreaterOrEqualXyc;
class KNumGreaterOrEqualXyc_I;
class KNumLessOrEqualXc;
class KNumLessOrEqualXc_I;
class KNumEqualXYZ;
class KNumEqualXYZ_I;
class KNumXEqualsYSquared;
class KNumXEqualsYSquared_I;
class KNumXEqualsYTimesC;
class KNumXEqualsYTimesC_I;
class KNumXEqualYArithPowC;
class KNumXEqualYArithPowC_I;
class KNumXEqualsLnY;
class KNumXEqualsLnY_I;
class KNumXEqualsAbsY;
class KNumXEqualsAbsY_I;
class KTaskArray;
class KResourceArray;
class KSolver;
class KTaskSerializer;
class KTaskSerializer_I;
class KFloatVar;
class KFloatVar_I;
class KGreaterOrEqualXc;
class KGreaterOrEqualXc_I;
class KGreaterOrEqualXyc;
class KGreaterOrEqualXyc_I;
class KGuard;
class KGuard_I;
class KIntervalDomain;
class KIntervalDomain_I;
class KIntArray;
class KTupleArray;
class KIntMatrix;
class KIntSetIntAnnotation;
class KIntVar;
class KIntVar_I;
class KIntVarArray;
class KIntVarBranchingScheme;
class KInputOrder;
class KInputOrder_I;
class KKnapsack;
class KKnapsack_I;
class KLessOrEqualXc;
class KLessOrEqualXc_I;
class KProbe_I;
class KProbeDisjunction_I;
class KProbe;
class KProbeDisjunction;
class KLinComb;
class KLinComb_I;
class KLinTerm;
class KMax;
class KMax_I;
class KMin;
class KMiddle_I;
class KNumMiddle_I;
class KMin_I;
class KNotEqualXc;
class KNotEqualXc_I;
class KNotEqualXyc;
class KNotEqualXyc_I;
class KNumLinComb;
class KNumLinComb_I;
class KNumVar;
class KNumVarArray;
class KNumVar_I;
class KNumXEqualsYTimesZ;
class KNumXEqualsYTimesZ_I;
class KOccurrence;
class KOccurrence_I;
class KOccurTerm;
class KProblem;
class KProblem_I;
class KSession;
class KSession_I;
class KSettleDisjunction_I;
class KSolution;
class KSolution_I;
class KSolutionArray;
class KSolutionContainer;
class KSolutionContainer_I;
class KSolver_I;
class KSolverEventListener;
class KParallelSolver_I;
class KSplitDomain;
class KSplitDomain_I;
class KSplitNumDomain;
class KSplitNumDomain_I;
class KTerm;
class KUnTerm;
class KUserConstraint;
class KUserConstraint_I;
class KUserNumConstraint;
class KUserNumConstraint_I;
class KUnaryResourceConstraint;
class KUnaryResourceConstraint_I;
class KCumulativeResourceConstraint;
class KCumulativeResourceConstraint_I;
class KValueSelector;
class KValueSelector_I;
class KNumValueSelector;
class KNumValueSelector_I;
class KVariableSelector;
class KVariableSelector_I;
class KNumVariableSelector;
class KNumVariableSelector_I;
class KXEqualYMinusZ;
class KXEqualYMinusZ_I;
class PropagateEvent;
class WorldManager;
class KGlobalCardinalityConstraint;
class KCompleteAllDifferentUsingGCC_I;
class KWidestDomain;
class KRelaxationSolverConfigurator;
class KRelaxationSolverConfigurator_I;
class KLinearRelaxationSolverConfigurator;
class KLinearRelaxationSolverConfigurator_I;
class KFloatVarBranchingScheme;
class KFloatVarSelector;
class KFloatVarSelector_I;
class KMessage;
class KMessage_I;
class KFinishedMessage;
class KFinishedMessage_I;
class KMessageBox;
class KMessageBox_I;
class KNonLinearTerm;
class KNumNonLinearComb;
class KNumXOperatorCosY;
class KNumXOperatorCosY_I;
class KNumXOperatorSinY;
class KNumXOperatorSinY_I;
class KNumXOperatorTanY;
class KNumXOperatorTanY_I;
class KNumXOperatorACosY;
class KNumXOperatorACosY_I;
class KNumXOperatorASinY;
class KNumXOperatorASinY_I;
class KNumXOperatorATanY;
class KNumXOperatorATanY_I;
class KNumXOperatorCoshY;
class KNumXOperatorCoshY_I;
class KNumXOperatorSinhY;
class KNumXOperatorSinhY_I;
class KNumXOperatorTanhY;
class KNumXOperatorTanhY_I;
class KNumXEqualsAtan2YZ;
class KNumXEqualsAtan2_Y_Z_I;
class KTask;
class KTask_I;
class KResource;
class KResource_I;
class KUnaryResource;
class KUnaryResource_I;
class KDiscreteResource;
class KDiscreteResource_I;
class KSchedule;
class KSchedule_I;
class KParallelSchedule_I;
class KMySettleDisjunction;
class KTaskSelector;
class KResourceUsage;
class KResourceUsageArray;
class KResourceUsage_I;
class KLargestMax;
class KLargestMax_I;
class KLargestMin;
class KLargestMin_I;
class KLargestReducedCost;
class KLargestReducedCost_I;
class KNumLargestReducedCost;
class KNumLargestReducedCost_I;
class KMaxDegree;
class KMaxDegree_I;
class KMaxRegretOnLowerBound;
class KMaxRegretOnLowerBound_I;
class KMaxRegretOnUpperBound;
class KMaxRegretOnUpperBound_I;
class KMostFractional;
class KMostFractional_I;
class KPathOrder;
class KPathOrder_I;
class KRandomVariable;
class KRandomVariable_I;
class KSmallestDomain;
class KSmallestDomain_I;
class KLargestDomain;
class KLargestDomain_I;
class KSmallestDomDegRatio;
class KSmallestDomDegRatio_I;
class KSmallestMax;
class KSmallestMax_I;
class KSmallestMin;
class KSmallestMin_I;
class KNumInputOrder;
class KNumInputOrder_I;

class KMaxToMin;
class KMaxToMin_I;
class KMiddle;
class KMiddle_I;
class KMinMaxConflict;
class KMinMaxConflict_I;
class KBestBoundValue;
class KBestBoundValue_I;
class KMinToMax;
class KMinToMax_I;
class KNearestRelaxedValue;
class KNearestRelaxedValue_I;
class KNearestValue;
class KNearestValue_I;
class KNearestNeighbor;
class KNearestNeighboor_I;
class KRandomValue;
class KRandomValue_I;
class KNumNearestValue;
class KNumNearestValue_I;
class KNumMiddle;
class KNumMiddle_I;
class KNumNearestRelaxedValue;
class KNumNearestRelaxedValue_I;

class KSearch;
class KSearch_I;
class KFindNextSolutionSearch;
class KFindNextSolutionSearch_I;

class KParallelBranchingScheme_I;

// Kalis hybrid
class KAuxVar;
class KAuxVar_I;
class KLinRel;
class KLinRel_I;
class KLinearRelaxation;
class KLinearRelaxation_I;
class KRelaxation;
class KRelaxation_I;
class KRelaxationSolver;
class KRelaxationSolver_I;
class KLinearRelaxationSolver;
class KLinearRelaxationSolver_I;
class KRelaxationSolver;
class KRelaxationSolver_I;
class KHybridSolution;
class KHybridSolution_I;
class KSolutionGetable_I;
class KIntermediateSolution_I;
class KTimeTable;
class KTimeTable_I;

template <class T> class StoredVal;
template <class T> class StoredValArray;
template <class T> class StoredValArrayStack;
template <class T> class StoredValStack;
template <class T> class StoredLinkedListElement;
template <class T> class StoredLinkedList;

typedef std::vector<AbstractNumVarConstraint *> AbstractNumVarConstraintListT;
typedef std::vector<AbstractEvent *> AbstractEventListT;
typedef std::vector<AbstractConstraint *> AbstractConstraintListT;
typedef std::vector<KDisjunction_I *> KDisjunction_IListT;
typedef std::vector<int> IntVectorT;
typedef std::vector<AbstractEventList *> AbstractEventListListT;
typedef std::vector<KIntVar_I *> KIntVar_IListT;
typedef std::vector<KFloatVar_I *> KFloatVar_IListT;
typedef std::vector<KNumVar_I *> KNumVar_IListT;
typedef std::vector<KMessageBox_I*> KMessageBox_IListT;

typedef int (*KalisCallBackFunctionPtr)(void*);
typedef int (PrintFunctionPtr)(void *ctx,const char * fmt);

DLLIMPORTEXPORT extern Console artelysConsole;

/*************************************************/
/*  >> General includes for extern classes       */
/*************************************************/
#include "KPtrArray.h"
#include "KCopiableObject.h"
#include "KAutoExternalObject.h"
#include "KExternalObject.h"

#endif // __GLOBALS_H__
