// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : Timer tools                                        *
// ********************************************************************

#ifndef __ARTELYSTIMER_H
#define __ARTELYSTIMER_H

#include "Globals.h"

class DLLIMPORTEXPORT ArtelysTimer {
  public:
    ArtelysTimer();
    ~ArtelysTimer();
    // First call to the clock, counter starts
    void initialize();
    // Call to the clock
    void update();
    // Give program time between the start of the counter and the
    // last call to the clock
    // (in seconds)
    double get_total_time() const;
    // Give program time between the two last calls to the clock
    // (in seconds)
    double get_incremental_time() const;
  private:
    // Last clock value
    double last_time;
    // Last date value (in Julian Day)
    double last_date;
    // Time increment between two clock calls
    double incremental_time;
    // Time since initialization
    double total_time;
}; // End of : class ArtelysTimer

#endif // End of : #ifndef ARTELYSTIMER
